
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
kiwis = m.addVar(lb=0, name="kiwis")
eggs = m.addVar(lb=0, name="eggs")
cherry_pies = m.addVar(lb=0, name="cherry_pies")

# Set objective function
m.setObjective(3 * kiwis * eggs + 2 * kiwis + 4 * eggs, GRB.MAXIMIZE)

# Add constraints
m.addConstr(11 * kiwis + 6 * eggs <= 172, "c1")
m.addConstr(11 * kiwis + 3 * cherry_pies <= 141, "c2")
m.addConstr(11 * kiwis + 6 * eggs + 3 * cherry_pies <= 141, "c3")
m.addConstr(5 * eggs + 7 * cherry_pies <= 82, "c4")
m.addConstr(kiwis * kiwis + eggs * eggs <= 83, "c5")  # Note: Quadratic constraint
m.addConstr(kiwis + eggs + cherry_pies <= 83, "c6")
m.addConstr(4 * kiwis * kiwis + 9 * eggs * eggs <= 84, "c7") # Note: Quadratic constraint
m.addConstr(4 * kiwis * kiwis + 9 * eggs * eggs + 3 * cherry_pies * cherry_pies <= 175, "c8") # Note: Quadratic constraint
m.addConstr(4 * kiwis + 9 * eggs + 3 * cherry_pies <= 175, "c9")


# Resource Constraints (given in the problem description)
m.addConstr(11 * kiwis + 6 * eggs + 3 * cherry_pies <= 187, "r0") # Healthiness
m.addConstr(1 * kiwis + 5 * eggs + 7 * cherry_pies <= 111, "r1") # Iron
m.addConstr(4 * kiwis + 9 * eggs + 3 * cherry_pies <= 195, "r2") # Carbs


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('kiwis:', kiwis.x)
    print('eggs:', eggs.x)
    print('cherry_pies:', cherry_pies.x)
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

