
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
kiwis = m.addVar(name="kiwis", lb=0)
eggs = m.addVar(name="eggs", lb=0)
cherry_pies = m.addVar(name="cherry_pies", lb=0)

# Objective function: Maximize 3 * kiwis * eggs + 2 * kiwis + 4 * eggs
m.setObjective(3 * kiwis * eggs + 2 * kiwis + 4 * eggs, GRB.MAXIMIZE)

# Constraints
m.addConstr(11 * kiwis + 6 * eggs <= 172, name="healthiness_kiwis_eggs")
m.addConstr(11 * kiwis + 3 * cherry_pies <= 141, name="healthiness_kiwis_cherry_pies")
m.addConstr(11 * kiwis + 6 * eggs + 3 * cherry_pies <= 141, name="total_healthiness")
m.addConstr(5 * eggs + 7 * cherry_pies <= 82, name="iron_eggs_cherry_pies")
m.addConstr(kiwis + 5 * eggs + 7 * cherry_pies <= 83, name="total_iron")
m.addConstr(4 * kiwis + 9 * eggs + 3 * cherry_pies <= 175, name="total_carbohydrates")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Kiwis: {kiwis.x}")
    print(f"Eggs: {eggs.x}")
    print(f"Cherry Pies: {cherry_pies.x}")
else:
    print("No optimal solution found")
