
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    kiwis = model.addVar(lb=0, name="kiwis", vtype=gurobi.GRB.CONTINUOUS)
    eggs = model.addVar(lb=0, name="eggs", vtype=gurobi.GRB.CONTINUOUS)
    cherry_pies = model.addVar(lb=0, name="cherry_pies", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(3 * kiwis * eggs + 2 * kiwis + 4 * eggs, gurobi.GRB.MAXIMIZE)

    # Healthiness rating constraints
    model.addConstr(11 * kiwis + 6 * eggs <= 172, name="healthiness_kiwis_eggs")
    model.addConstr(11 * kiwis + 3 * cherry_pies <= 141, name="healthiness_kiwis_pies")
    model.addConstr(11 * kiwis + 6 * eggs + 3 * cherry_pies <= 141, name="healthiness_all")

    # Milligrams of iron constraints
    model.addConstr(5 * eggs + 7 * cherry_pies <= 82, name="iron_eggs_pies")
    model.addConstr(kiwis**2 + eggs**2 <= 83, name="iron_kiwis_eggs_squared")
    model.addConstr(kiwis + eggs + cherry_pies <= 83, name="iron_all")

    # Grams of carbohydrates constraints
    model.addConstr(kiwis**2 + eggs**2 <= 84, name="carbohydrates_kiwis_eggs_squared")
    model.addConstr(kiwis**2 + eggs**2 + cherry_pies**2 <= 175, name="carbohydrates_all_squared")
    model.addConstr(kiwis + eggs + cherry_pies <= 175, name="carbohydrates_all")

    # Parameters for resources
    model.addConstr(kiwis * 11 <= 187, name="r0_kiwis")
    model.addConstr(eggs * 6 <= 187, name="r0_eggs")
    model.addConstr(cherry_pies * 3 <= 187, name="r0_pies")

    model.addConstr(kiwis * 1 <= 111, name="r1_kiwis")
    model.addConstr(eggs * 5 <= 111, name="r1_eggs")
    model.addConstr(cherry_pies * 7 <= 111, name="r1_pies")

    model.addConstr(kiwis * 4 <= 195, name="r2_kiwis")
    model.addConstr(eggs * 9 <= 195, name="r2_eggs")
    model.addConstr(cherry_pies * 3 <= 195, name="r2_pies")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Kiwis: ", kiwis.varValue)
        print("Eggs: ", eggs.varValue)
        print("Cherry Pies: ", cherry_pies.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
