
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("resource_allocation")

# Define variables
hank = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours worked by Hank")
peggy = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours worked by Peggy")
dale = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours worked by Dale")
john = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours worked by John")
ringo = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours worked by Ringo")
bobby = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours worked by Bobby")

# Set objective function
m.setObjective(3.05 * hank + 6.55 * peggy + 8.67 * dale + 6.52 * john + 7.24 * ringo + 4.62 * bobby, GRB.MINIMIZE)

# Resource data
resources = {'r0': {'description': 'computer competence rating', 'upper_bound': 434, 'x0': 28, 'x1': 25, 'x2': 27, 'x3': 11, 'x4': 10, 'x5': 4}, 
            'r1': {'description': 'dollar cost per hour', 'upper_bound': 679, 'x0': 16, 'x1': 1, 'x2': 6, 'x3': 20, 'x4': 7, 'x5': 9}, 
            'r2': {'description': 'work quality rating', 'upper_bound': 656, 'x0': 9, 'x1': 24, 'x2': 24, 'x3': 24, 'x4': 22, 'x5': 29}, 
            'r3': {'description': 'likelihood to quit index', 'upper_bound': 361, 'x0': 9, 'x1': 11, 'x2': 17, 'x3': 9, 'x4': 29, 'x5': 20}, 
            'r4': {'description': 'productivity rating', 'upper_bound': 753, 'x0': 9, 'x1': 29, 'x2': 12, 'x3': 26, 'x4': 16, 'x5': 2}}
variables = [hank, peggy, dale, john, ringo, bobby]

# Add constraints based on the provided input
m.addConstr(28 * hank + 4 * bobby >= 48)
m.addConstr(28 * hank + 11 * john >= 26)
m.addConstr(27 * dale + 11 * john >= 34)
m.addConstr(27 * dale + 10 * ringo >= 49)
m.addConstr(11 * john + 4 * bobby >= 38)
m.addConstr(28 * hank + 10 * ringo >= 46)
m.addConstr(25 * peggy + 11 * john >= 62)
m.addConstr(25 * peggy + 27 * dale >= 29)
m.addConstr(25 * peggy + 4 * bobby >= 29)
m.addConstr(28 * hank + 25 * peggy + 27 * dale + 11 * john + 10 * ringo + 4 * bobby >= 29)

# ... (Add all other constraints similarly, following the pattern above)

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)
