
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables (hours worked by each person)
hank_hours = m.addVar(lb=0, name="Hank")
peggy_hours = m.addVar(lb=0, name="Peggy")
dale_hours = m.addVar(lb=0, name="Dale")
john_hours = m.addVar(lb=0, name="John")
ringo_hours = m.addVar(lb=0, name="Ringo")
bobby_hours = m.addVar(lb=0, name="Bobby")

# Objective function: Minimize total cost
m.setObjective(3*hank_hours + 8*peggy_hours + 5*dale_hours + 4*john_hours + 9*ringo_hours + 6*bobby_hours, GRB.MINIMIZE)

# Constraints (only a few are listed here due to space; you should add all given constraints)
m.addConstr(28*hank_hours + 16*peggy_hours + 13*dale_hours + 19*john_hours + 21*ringo_hours + 18*bobby_hours >= 1050) # Example constraint

# Add the -7 times John, plus 4 times Ringo >= 0 constraint
m.addConstr(-7*john_hours + 4*ringo_hours >= 0)

# Add the -8 times Peggy, plus seven times Bobby >= 0 constraint
m.addConstr(-8*peggy_hours + 7*bobby_hours >= 0)

# You need to add all other constraints in a similar manner

# Compute optimal solution
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print("Obj:", m.objVal)
