
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
Hank = m.addVar(name="Hank", lb=0)  # hours worked by Hank
Peggy = m.addVar(name="Peggy", lb=0)  # hours worked by Peggy
Dale = m.addVar(name="Dale", lb=0)  # hours worked by Dale
John = m.addVar(name="John", lb=0)  # hours worked by John
Ringo = m.addVar(name="Ringo", lb=0)  # hours worked by Ringo
Bobby = m.addVar(name="Bobby", lb=0)  # hours worked by Bobby

# Define the objective function
m.setObjective(3.05 * Hank + 6.55 * Peggy + 8.67 * Dale + 6.52 * John + 7.24 * Ringo + 4.62 * Bobby, gp.GRB.MINIMIZE)

# Define the constraints
# Computer competence rating constraints
m.addConstr(28 * Hank + 4 * Bobby >= 48)
m.addConstr(28 * Hank + 11 * John >= 26)
m.addConstr(27 * Dale + 11 * John >= 34)
m.addConstr(27 * Dale + 10 * Ringo >= 49)
m.addConstr(11 * John + 4 * Bobby >= 38)
m.addConstr(28 * Hank + 10 * Ringo >= 46)
m.addConstr(25 * Peggy + 11 * John >= 62)
m.addConstr(25 * Peggy + 27 * Dale >= 29)
m.addConstr(25 * Peggy + 4 * Bobby >= 29)
m.addConstr(28 * Hank + 25 * Peggy + 27 * Dale + 11 * John + 10 * Ringo + 4 * Bobby >= 29)

# Dollar cost per hour constraints
m.addConstr(1 * Peggy + 20 * John >= 99)
m.addConstr(1 * Peggy + 6 * Dale >= 71)
m.addConstr(16 * Hank + 20 * John >= 63)
m.addConstr(20 * John + 9 * Bobby >= 70)
m.addConstr(7 * Ringo + 9 * Bobby >= 39)
m.addConstr(1 * Peggy + 7 * Ringo >= 101)
m.addConstr(16 * Hank + 1 * Peggy + 6 * Dale + 20 * John + 7 * Ringo + 9 * Bobby >= 101)

# Work quality rating constraints
m.addConstr(24 * Peggy + 24 * John >= 71)
m.addConstr(9 * Hank + 24 * Dale >= 83)
m.addConstr(24 * Dale + 22 * Ringo >= 39)
m.addConstr(24 * Peggy + 29 * Bobby >= 78)
m.addConstr(24 * Dale + 24 * John >= 49)
m.addConstr(24 * Dale + 29 * Bobby >= 42)
m.addConstr(9 * Hank + 22 * Ringo + 29 * Bobby >= 95)
m.addConstr(24 * Peggy + 22 * Ringo + 29 * Bobby >= 95)
m.addConstr(9 * Hank + 24 * Peggy + 29 * Bobby >= 95)
m.addConstr(9 * Hank + 24 * Dale + 29 * Bobby >= 95)
m.addConstr(9 * Hank + 22 * Ringo + 29 * Bobby >= 78)
m.addConstr(24 * Peggy + 22 * Ringo + 29 * Bobby >= 78)
m.addConstr(9 * Hank + 24 * Peggy + 29 * Bobby >= 78)
m.addConstr(9 * Hank + 24 * Dale + 29 * Bobby >= 78)
m.addConstr(9 * Hank + 22 * Ringo + 29 * Bobby >= 105)
m.addConstr(24 * Peggy + 22 * Ringo + 29 * Bobby >= 105)
m.addConstr(9 * Hank + 24 * Peggy + 29 * Bobby >= 105)
m.addConstr(9 * Hank + 24 * Dale + 29 * Bobby >= 105)

# Likelihood to quit index constraints
m.addConstr(29 * Ringo + 20 * Bobby >= 55)
m.addConstr(11 * Peggy + 17 * Dale >= 51)
m.addConstr(9 * Hank + 9 * John >= 34)
m.addConstr(17 * Dale + 9 * John >= 27)
m.addConstr(9 * Hank + 29 * Ringo >= 32)
m.addConstr(11 * Peggy + 9 * John >= 22)
m.addConstr(9 * John + 29 * Ringo >= 41)
m.addConstr(17 * Dale + 20 * Bobby >= 22)
m.addConstr(11 * Peggy + 17 * Dale + 9 * John >= 60)
m.addConstr(17 * Dale + 29 * Ringo + 20 * Bobby >= 60)
m.addConstr(9 * Hank + 9 * John + 20 * Bobby >= 60)

# Productivity rating constraints
m.addConstr(9 * Hank + 12 * Dale >= 66)
m.addConstr(16 * Ringo + 2 * Bobby >= 85)
m.addConstr(9 * Hank + 29 * Peggy + 12 * Dale + 26 * John + 16 * Ringo + 2 * Bobby >= 85)

# Other constraints
m.addConstr(-7 * John + 4 * Ringo >= 0)
m.addConstr(-8 * Peggy + 7 * Bobby >= 0)
m.addConstr(-4 * Peggy + 1 * Dale + 10 * Ringo >= 0)

m.addConstr(25 * Peggy + 10 * Ringo + 4 * Bobby <= 256)
m.addConstr(11 * John + 10 * Ringo + 4 * Bobby <= 244)

m.addConstr(16 * Hank + 6 * Dale + 20 * John <= 597)
m.addConstr(6 * Dale + 20 * John + 7 * Ringo <= 257)
m.addConstr(16 * Hank + 1 * Peggy + 6 * Dale <= 274)
m.addConstr(20 * John + 7 * Ringo + 9 * Bobby <= 480)
m.addConstr(6 * Dale + 7 * Ringo + 9 * Bobby <= 370)
m.addConstr(1 * Peggy + 6 * Dale + 9 * Bobby <= 462)
m.addConstr(16 * Hank + 20 * John + 7 * Ringo <= 253)
m.addConstr(16 * Hank + 1 * Peggy + 7 * Ringo <= 557)
m.addConstr(16 * Hank + 20 * John + 9 * Bobby <= 665)
m.addConstr(1 * Peggy + 7 * Ringo + 9 * Bobby <= 361)
m.addConstr(16 * Hank + 7 * Ringo + 9 * Bobby <= 611)
m.addConstr(1 * Peggy + 20 * John + 9 * Bobby <= 592)
m.addConstr(1 * Peggy + 20 * John + 7 * Ringo <= 629)
m.addConstr(1 * Peggy + 6 * Dale + 7 * Ringo <= 369)

m.addConstr(24 * Dale + 22 * Ringo <= 590)
m.addConstr(17 * Dale + 9 * John + 29 * Ringo <= 220)
m.addConstr(9 * John + 29 * Ringo + 20 * Bobby <= 107)
m.addConstr(9 * Hank + 29 * Ringo + 20 * Bobby <= 323)
m.addConstr(9 * Hank + 9 * John + 20 * Bobby <= 214)
m.addConstr(11 * Peggy + 9 * John + 29 * Ringo <= 234)
m.addConstr(11 * Peggy + 9 * John + 20 * Bobby <= 165)
m.addConstr(11 * Peggy + 29 * Ringo + 20 * Bobby <= 203)
m.addConstr(9 * Hank + 11 * Peggy + 29 * Ringo <= 189)
m.addConstr(11 * Peggy + 17 * Dale + 29 * Ringo <= 149)
m.addConstr(17 * Dale + 9 * John + 20 * Bobby <= 211)
m.addConstr(9 * Hank + 11 * Peggy + 17 * Dale <= 293)
m.addConstr(9 * Hank + 11 * Peggy + 20 * Bobby <= 274)

m.addConstr(29 * Peggy + 12 * Dale + 16 * Ringo <= 555)
m.addConstr(9 * Hank + 12 * Dale + 29 * Bobby <= 666)
m.addConstr(9 * Hank + 12 * Dale + 26 * John <= 172)
m.addConstr(12 * Dale + 26 * John + 16 * Ringo <= 667)
m.addConstr(29 * Peggy + 26 * John + 16 * Ringo <= 643)
m.addConstr(26 * John + 16 * Ringo + 20 * Bobby <= 132)
m.addConstr(29 * Peggy + 12 * Dale + 26 * John <= 479)
m.addConstr(9 * Hank + 29 * Peggy + 26 * John <= 702)
m.addConstr(9 * Hank + 29 * Peggy + 29 * Bobby <= 553)
m.addConstr(9 * Hank + 29 * Peggy + 16 * Ringo <= 579)
m.addConstr(9 * Hank + 26 * John + 16 * Ringo <= 302)
m.addConstr(9 * Hank + 26 * John + 29 * Bobby <= 133)
m.addConstr(9 * Hank + 16 * Ringo + 29 * Bobby <= 736)
m.addConstr(29 * Peggy + 12 * Dale + 29 * Bobby <= 739)
m.addConstr(9 * Hank + 29 * Peggy + 12 * Dale <= 449)
m.addConstr(12 * Dale + 16 * Ringo + 29 * Bobby <= 255)

# Solve the problem
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Hank:", Hank.varValue)
    print("Peggy:", Peggy.varValue)
    print("Dale:", Dale.varValue)
    print("John:", John.varValue)
    print("Ringo:", Ringo.varValue)
    print("Bobby:", Bobby.varValue)
else:
    print("No optimal solution found.")
