
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
b7 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="B7")
b5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="B5")
c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="C")

# Set objective function
m.setObjective(3.31 * b7 + 7.64 * b5 + 8.06 * c, gp.GRB.MINIMIZE)

# Add constraints based on resource indices
m.addConstr(10 * b7 + 5 * b5 + 8 * c <= 158, "digestive_support_ub") # Using provided upper bound
m.addConstr(8 * b7 + 12 * b5 + 11 * c <= 130, "energy_stability_ub") # Using provided upper bound
m.addConstr(2 * b7 + 20 * b5 + 4 * c <= 124, "immune_support_ub") # Using provided upper bound


# Add additional constraints from the problem description
m.addConstr(10 * b7 + 5 * b5 >= 52, "digestive_support_b7_b5")
m.addConstr(5 * b5 + 8 * c >= 23, "digestive_support_b5_c")
m.addConstr(10 * b7 + 5 * b5 + 8 * c >= 40, "digestive_support_all_1")
m.addConstr(10 * b7 + 5 * b5 + 8 * c >= 40, "digestive_support_all_2") # Redundant constraint
m.addConstr(12 * b5 + 11 * c >= 38, "energy_stability_b5_c")
m.addConstr(8 * b7 + 12 * b5 + 11 * c >= 38, "energy_stability_all")
m.addConstr(2 * b7 + 4 * c >= 22, "immune_support_b7_c")
m.addConstr(20 * b5 + 4 * c >= 36, "immune_support_b5_c_geq")
m.addConstr(2 * b7 + 20 * b5 + 4 * c >= 36, "immune_support_all")
m.addConstr(-7 * b5 + 9 * c >= 0, "constraint_b5_c")
m.addConstr(-3 * b7 + 7 * c >= 0, "constraint_b7_c")
m.addConstr(10 * b7 + 5 * b5 + 8 * c <= 76, "digestive_support_ub_2") # Added upper bound constraint
m.addConstr(2 * b7 + 4 * c <= 120, "immune_support_b7_c_ub")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('B7:', b7.x)
    print('B5:', b5.x)
    print('C:', c.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

