
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define the decision variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B7")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B5")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_C")

# Objective function: minimize
m.setObjective(3.31*x0 + 7.64*x1 + 8.06*x2, GRB.MINIMIZE)

# Constraints
m.addConstr(10*x0 >= 52, "digestive_support_index_B7")
m.addConstr(5*x1 + 8*x2 >= 23, "digestive_support_index_B5_C")
m.addConstr(10*x0 + 5*x1 + 8*x2 >= 40, "total_digestive_support_min")
m.addConstr(10*x0 + 5*x1 + 8*x2 <= 76, "total_digestive_support_max")

m.addConstr(12*x1 + 11*x2 >= 38, "energy_stability_index_B5_C")
m.addConstr(8*x0 + 12*x1 + 11*x2 >= 38, "total_energy_stability_min")

m.addConstr(2*x0 + 4*x2 >= 22, "immune_support_index_B7_C")
m.addConstr(20*x1 + 4*x2 >= 36, "immune_support_index_B5_C")
m.addConstr(2*x0 + 20*x1 + 4*x2 >= 36, "total_immune_support_min")

m.addConstr(-7*x1 + 9*x2 >= 0, "additional_constraint_1")
m.addConstr(-3*x0 + 7*x2 >= 0, "additional_constraint_2")
m.addConstr(2*x0 + 4*x2 <= 120, "immune_support_index_B7_C_max")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B7: {x0.x}")
    print(f"Milligrams of Vitamin B5: {x1.x}")
    print(f"Milligrams of Vitamin C: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
