
import gurobi

def optimize_vitamins():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(lb=0, name="milligrams of vitamin B7")
    x1 = model.addVar(lb=0, name="milligrams of vitamin B5")
    x2 = model.addVar(lb=0, name="milligrams of vitamin C")

    # Objective function
    model.setObjective(3.31 * x0 + 7.64 * x1 + 8.06 * x2, gurobi.GRB.MINIMIZE)

    # Digestive support index constraints
    model.addConstr(10 * x0 + 5 * x1 + 8 * x2 >= 52, name="digestive_support_index_constraint1")
    model.addConstr(5 * x1 + 8 * x2 >= 23, name="digestive_support_index_constraint2")
    model.addConstr(10 * x0 + 5 * x1 + 8 * x2 >= 40, name="digestive_support_index_constraint3")
    model.addConstr(10 * x0 + 5 * x1 + 8 * x2 <= 76, name="digestive_support_index_constraint4")

    # Energy stability index constraints
    model.addConstr(8 * x0 + 12 * x1 + 11 * x2 >= 38, name="energy_stability_index_constraint1")

    # Immune support index constraints
    model.addConstr(2 * x0 + 4 * x2 >= 22, name="immune_support_index_constraint1")
    model.addConstr(20 * x1 + 4 * x2 >= 36, name="immune_support_index_constraint2")
    model.addConstr(2 * x0 + 20 * x1 + 4 * x2 >= 36, name="immune_support_index_constraint3")

    # Additional constraints
    model.addConstr(-7 * x1 + 9 * x2 >= 0, name="additional_constraint1")
    model.addConstr(-3 * x0 + 7 * x2 >= 0, name="additional_constraint2")

    # Upper bounds for indexes (assuming these are not directly applicable as shown)
    # model.addConstr(10 * x0 + 5 * x1 + 8 * x2 <= 158, name="r0_constraint") 
    # model.addConstr(8 * x0 + 12 * x1 + 11 * x2 <= 130, name="r1_constraint")
    # model.addConstr(2 * x0 + 20 * x1 + 4 * x2 <= 124, name="r2_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B7: {x0.varValue}")
        print(f"Milligrams of vitamin B5: {x1.varValue}")
        print(f"Milligrams of vitamin C: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
