
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
foods = ['oreos', 'hamburgers', 'bananas', 'blueberry pies', 'kiwis', 'oranges', 'ravioli', 'chicken drumsticks']
x = m.addVars(foods, lb=0.0, name="x")

# Set objective function
objective = 2.02 * x['oreos'] + 2.49 * x['hamburgers'] + 3.21 * x['bananas'] + 9.61 * x['blueberry pies'] + 8.59 * x['kiwis'] + 1.08 * x['oranges'] + 2.35 * x['ravioli'] + 6.31 * x['chicken drumsticks']
m.setObjective(objective, gp.GRB.MINIMIZE)

# Resource constraints
resources = {
    'r0': {'description': 'milligrams of iron', 'upper_bound': 238, 'values': [3, 4, 2, 9, 6, 3, 11, 4]},
    'r1': {'description': 'grams of carbohydrates', 'upper_bound': 426, 'values': [10, 7, 6, 6, 6, 8, 4, 11]},
    'r2': {'description': 'grams of fiber', 'upper_bound': 385, 'values': [1, 8, 11, 7, 6, 5, 10, 9]}
}

for r, data in resources.items():
    m.addConstr(sum(data['values'][i] * x[foods[i]] for i in range(len(foods))) <= data['upper_bound'], name=r)

# Additional constraints (iron)
m.addConstr(3 * x['oreos'] + 3 * x['oranges'] >= 9)
m.addConstr(6 * x['kiwis'] + 4 * x['chicken drumsticks'] >= 15)
m.addConstr(3 * x['oranges'] + 4 * x['chicken drumsticks'] >= 24)
m.addConstr(3 * x['oreos'] + 9 * x['blueberry pies'] >= 9)
m.addConstr(3 * x['oreos'] + 6 * x['kiwis'] >= 15)
m.addConstr(6 * x['kiwis'] + 3 * x['oranges'] >= 26)
m.addConstr(3 * x['oreos'] + 4 * x['chicken drumsticks'] >= 14)
m.addConstr(9 * x['blueberry pies'] + 3 * x['oranges'] >= 17)
m.addConstr(4 * x['hamburgers'] + 4 * x['chicken drumsticks'] >= 13)
m.addConstr(2 * x['bananas'] + 9 * x['blueberry pies'] >= 11)
m.addConstr(2 * x['bananas'] + 6 * x['kiwis'] >= 9)
m.addConstr(3 * x['oreos'] + 4 * x['hamburgers'] >= 12)
m.addConstr(2 * x['bananas'] + 3 * x['oranges'] >= 9)
m.addConstr(4 * x['hamburgers'] + 6 * x['kiwis'] >= 29)
m.addConstr(4 * x['hamburgers'] + 2 * x['bananas'] >= 22)
m.addConstr(3 * x['oreos'] + 11 * x['ravioli'] >= 28)
m.addConstr(3 * x['oranges'] + 11 * x['ravioli'] >= 15)
m.addConstr(3 * x['oreos'] + 2 * x['bananas'] >= 23)
m.addConstr(4 * x['hamburgers'] + 9 * x['blueberry pies'] >= 26)
m.addConstr(9 * x['blueberry pies'] + 4 * x['chicken drumsticks'] >= 24)

# ... (rest of the constraints, following the same pattern)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

