
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
lemons = m.addVar(vtype=gp.GRB.INTEGER, name="lemons")
peanutbutter_sandwiches = m.addVar(vtype=gp.GRB.INTEGER, name="peanutbutter_sandwiches")
hamburgers = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hamburgers")
pizza_slices = m.addVar(vtype=gp.GRB.INTEGER, name="pizza_slices")

# Set objective function
m.setObjective(6.6 * lemons + 7.81 * peanutbutter_sandwiches + 2.96 * hamburgers + 9.02 * pizza_slices, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * lemons + 30 * peanutbutter_sandwiches + 9 * hamburgers + 19 * pizza_slices <= 696, "iron_limit") #r0
m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches + 9 * hamburgers + 11 * pizza_slices <= 295, "umami_limit") #r1

m.addConstr(30 * peanutbutter_sandwiches + 9 * hamburgers >= 141, "iron_pb_h")
m.addConstr(14 * lemons + 9 * hamburgers >= 102, "iron_l_h")
m.addConstr(14 * lemons + 19 * pizza_slices >= 64, "iron_l_p")
m.addConstr(14 * lemons + 9 * hamburgers + 19 * pizza_slices >= 122, "iron_l_h_p")
m.addConstr(30 * peanutbutter_sandwiches + 9 * hamburgers + 19 * pizza_slices >= 122, "iron_pb_h_p")
m.addConstr(14 * lemons + 9 * hamburgers + 19 * pizza_slices >= 166, "iron_l_h_p_2")
m.addConstr(30 * peanutbutter_sandwiches + 9 * hamburgers + 19 * pizza_slices >= 166, "iron_pb_h_p_2")

m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches + 9 * hamburgers >= 65, "umami_l_pb_h")
m.addConstr(30 * lemons + 9 * hamburgers + 11 * pizza_slices >= 65, "umami_l_h_p")
m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches + 11 * pizza_slices >= 65, "umami_l_pb_p")
m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches + 9 * hamburgers >= 54, "umami_l_pb_h_2")
m.addConstr(30 * lemons + 9 * hamburgers + 11 * pizza_slices >= 54, "umami_l_h_p_2")
m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches + 11 * pizza_slices >= 54, "umami_l_pb_p_2")
m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches + 9 * hamburgers >= 42, "umami_l_pb_h_3")
m.addConstr(30 * lemons + 9 * hamburgers + 11 * pizza_slices >= 42, "umami_l_h_p_3")
m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches + 11 * pizza_slices >= 42, "umami_l_pb_p_3")


m.addConstr(14 * lemons + 9 * hamburgers <= 217, "iron_l_h_ub")
m.addConstr(14 * lemons + 30 * peanutbutter_sandwiches <= 401, "iron_l_pb_ub")
m.addConstr(30 * peanutbutter_sandwiches + 9 * hamburgers <= 623, "iron_pb_h_ub")
m.addConstr(14 * lemons + 30 * peanutbutter_sandwiches + 9 * hamburgers + 19 * pizza_slices <= 623, "iron_all_ub")

m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches <= 214, "umami_l_pb_ub")
m.addConstr(19 * peanutbutter_sandwiches + 11 * pizza_slices <= 109, "umami_pb_p_ub")
m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches + 11 * pizza_slices <= 94, "umami_l_pb_p_ub")
m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches + 9 * hamburgers + 11 * pizza_slices <= 94, "umami_all_ub")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('lemons:', lemons.x)
    print('peanutbutter_sandwiches:', peanutbutter_sandwiches.x)
    print('hamburgers:', hamburgers.x)
    print('pizza_slices:', pizza_slices.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

