
import gurobipy as gp

# Create a new model
m = gp.Model("Work_Optimization")

# Create variables
jean_hours = m.addVar(vtype=gp.GRB.CONTINUOUS, name="jean_hours")
laura_hours = m.addVar(vtype=gp.GRB.CONTINUOUS, name="laura_hours")
hank_hours = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hank_hours")

# Set objective function
m.setObjective(9 * jean_hours + 7 * laura_hours + 5 * hank_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(22 * jean_hours + 20 * laura_hours + 25 * hank_hours >= 118, "paperwork_competence_total_min")
m.addConstr(22 * laura_hours + 23 * hank_hours >= 41, "productivity_laura_hank_min")
m.addConstr(14 * jean_hours + 22 * laura_hours >= 67, "productivity_jean_laura_min")
m.addConstr(14 * jean_hours + 23 * hank_hours >= 48, "productivity_jean_hank_min")
m.addConstr(14 * jean_hours + 22 * laura_hours + 23 * hank_hours >= 65, "productivity_total_min")

m.addConstr(22 * jean_hours + 20 * laura_hours <= 195, "paperwork_jean_laura_max")
m.addConstr(22 * jean_hours + 20 * laura_hours + 25 * hank_hours <= 195, "paperwork_total_max")
m.addConstr(14 * jean_hours + 23 * hank_hours <= 152, "productivity_jean_hank_max")
m.addConstr(22 * laura_hours + 23 * hank_hours <= 164, "productivity_laura_hank_max")
m.addConstr(14 * jean_hours + 22 * laura_hours <= 143, "productivity_jean_laura_max")
m.addConstr(14 * jean_hours + 22 * laura_hours + 23 * hank_hours <= 143, "productivity_total_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f"Jean's hours: {jean_hours.x}")
    print(f"Laura's hours: {laura_hours.x}")
    print(f"Hank's hours: {hank_hours.x}")
    print(f"Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible.')
else:
    print(f"Optimization ended with status {m.status}")

