
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
J = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Jean")
L = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Laura")
H = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")

# Objective function
m.setObjective(9*J + 7*L + 5*H, GRB.MAXIMIZE)

# Constraints
# Paperwork competence constraints
m.addConstr(22*J + 20*L + 25*H >= 118, "total_paperwork_competence")
m.addConstr(22*J + 20*L <= 195, "paperwork_JL")
m.addConstr(22*J + 20*L + 25*H <= 195, "total_paperwork")

# Productivity constraints
m.addConstr(22*L + 23*H >= 41, "productivity_LH_min")
m.addConstr(14*J + 22*L >= 67, "productivity_JL_min")
m.addConstr(14*J + 23*H >= 48, "productivity_JH_min")
m.addConstr(14*J + 22*L + 23*H >= 65, "total_productivity_min")

m.addConstr(14*J + 23*H <= 152, "productivity_JH_max")
m.addConstr(22*L + 23*H <= 164, "productivity_LH_max")
m.addConstr(14*J + 22*L <= 143, "productivity_JL_max")
m.addConstr(14*J + 22*L + 23*H <= 143, "total_productivity_max")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Jean: {J.x}")
    print(f"Hours worked by Laura: {L.x}")
    print(f"Hours worked by Hank: {H.x}")
else:
    print("No optimal solution found")
