
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    jean_hours = model.addVar(name="jean_hours", lb=0, ub=None)  # Can be fractional
    laura_hours = model.addVar(name="laura_hours", lb=0, ub=None)  # Can be fractional
    hank_hours = model.addVar(name="hank_hours", lb=0, ub=None)  # Can be fractional

    # Objective function
    model.setObjective(9 * jean_hours + 7 * laura_hours + 5 * hank_hours, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(22 * jean_hours + 20 * laura_hours + 25 * hank_hours >= 118)  # Paperwork competence rating
    model.addConstr(22 * laura_hours + 23 * hank_hours >= 41)  # Productivity rating of Laura and Hank
    model.addConstr(14 * jean_hours + 22 * laura_hours >= 67)  # Productivity rating of Jean and Laura
    model.addConstr(14 * jean_hours + 23 * hank_hours >= 48)  # Productivity rating of Jean and Hank
    model.addConstr(14 * jean_hours + 22 * laura_hours + 23 * hank_hours >= 65)  # Total productivity rating
    model.addConstr(22 * jean_hours + 20 * laura_hours <= 195)  # Paperwork competence rating of Jean and Laura
    model.addConstr(22 * jean_hours + 20 * laura_hours + 25 * hank_hours <= 423)  # Total paperwork competence rating
    model.addConstr(14 * jean_hours + 23 * hank_hours <= 152)  # Productivity rating of Jean and Hank
    model.addConstr(22 * laura_hours + 23 * hank_hours <= 164)  # Productivity rating of Laura and Hank
    model.addConstr(14 * jean_hours + 22 * laura_hours <= 143)  # Productivity rating of Jean and Laura
    model.addConstr(14 * jean_hours + 22 * laura_hours + 23 * hank_hours <= 143)  # Total productivity rating

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Jean's hours: {jean_hours.varValue}")
        print(f"Laura's hours: {laura_hours.varValue}")
        print(f"Hank's hours: {hank_hours.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
