
from gurobipy import Model, GRB

# Create a new model
m = Model("military_optimization")

# Create variables
pathfinder_teams = m.addVar(vtype=GRB.INTEGER, name="pathfinder_teams")
recon_troops = m.addVar(vtype=GRB.INTEGER, name="recon_troops")

# Set objective function
m.setObjective(1.09 * pathfinder_teams + 7.7 * recon_troops, GRB.MINIMIZE)

# Add constraints
m.addConstr(23 * pathfinder_teams + 10 * recon_troops >= 45, "offensive_capability_min")
m.addConstr(21 * pathfinder_teams + 19 * recon_troops >= 65, "mobility_min")
m.addConstr(6 * pathfinder_teams - 2 * recon_troops >= 0, "pathfinder_recon_ratio")
m.addConstr(23 * pathfinder_teams + 10 * recon_troops <= 188, "offensive_capability_max")  # Corrected upper bound constraint
m.addConstr(21 * pathfinder_teams + 19 * recon_troops <= 141, "mobility_max")  # Corrected upper bound constraint


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Pathfinder Teams: {pathfinder_teams.x}")
    print(f"  Recon Troops: {recon_troops.x}")
    print(f"  Objective Value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {m.status}")

