
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
pathfinder_teams = m.addVar(vtype=GRB.INTEGER, name="pathfinder_teams")
reconnaissance_troops = m.addVar(vtype=GRB.INTEGER, name="reconnaissance_troops")

# Objective function: Minimize 1.09 * pathfinder_teams + 7.7 * reconnaissance_troops
m.setObjective(1.09 * pathfinder_teams + 7.7 * reconnaissance_troops, GRB.MINIMIZE)

# Constraints
# Total combined offensive capability rating >= 45
m.addConstr(23 * pathfinder_teams + 10 * reconnaissance_troops >= 45, "offensive_capability_min")

# Total combined mobility rating >= 65
m.addConstr(21 * pathfinder_teams + 19 * reconnaissance_troops >= 65, "mobility_rating_min")

# 6 * pathfinder_teams - 2 * reconnaissance_troops >= 0
m.addConstr(6 * pathfinder_teams - 2 * reconnaissance_troops >= 0, "custom_constraint")

# Total combined offensive capability rating <= 188
m.addConstr(23 * pathfinder_teams + 10 * reconnaissance_troops <= 188, "offensive_capability_max")

# Total combined mobility rating <= 141
m.addConstr(21 * pathfinder_teams + 19 * reconnaissance_troops <= 141, "mobility_rating_max")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pathfinder Teams: {pathfinder_teams.x}")
    print(f"Reconnaissance Troops: {reconnaissance_troops.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
