
import gurobipy as gp

# Create a new model
m = gp.Model("pathfinder_reconnaissance")

# Define the variables
x0 = m.addVar(name="pathfinder_teams", vtype=gp.GRB.INTEGER)  # pathfinder teams
x1 = m.addVar(name="reconnaissance_troops", vtype=gp.GRB.INTEGER)  # reconnaissance troops

# Objective function: Minimize 1.09 * x0 + 7.7 * x1
m.setObjective(1.09 * x0 + 7.7 * x1, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(23 * x0 + 10 * x1 >= 45, name="offensive_capability_min")
m.addConstr(21 * x0 + 19 * x1 >= 65, name="mobility_rating_min")
m.addConstr(6 * x0 - 2 * x1 >= 0, name="pathfinder_reconnaissance_balance")
m.addConstr(23 * x0 + 10 * x1 <= 188, name="offensive_capability_max")
m.addConstr(21 * x0 + 19 * x1 <= 141, name="mobility_rating_max")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Pathfinder Teams: {x0.varValue}")
    print(f"Reconnaissance Troops: {x1.varValue}")
    print(f"Objective Value: {m.objVal}")
else:
    print("No optimal solution found.")
