
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_k")
    vitamin_b6 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b6")

    # Set objective function
    m.setObjective(3 * vitamin_k + 6 * vitamin_b6, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(9 * vitamin_k + 8 * vitamin_b6 >= 28, "digestive_support_min")
    m.addConstr(9 * vitamin_k + 20 * vitamin_b6 >= 13, "energy_stability_min")
    m.addConstr(11 * vitamin_k + 17 * vitamin_b6 >= 29, "cognitive_performance_min")
    m.addConstr(-7 * vitamin_k + 9 * vitamin_b6 >= 0, "custom_constraint")
    m.addConstr(9 * vitamin_k + 8 * vitamin_b6 <= 57, "digestive_support_max")
    m.addConstr(9 * vitamin_k + 20 * vitamin_b6 <= 49, "energy_stability_max")
    m.addConstr(11 * vitamin_k + 17 * vitamin_b6 <= 59, "cognitive_performance_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution found:")
        print(f"  Milligrams of Vitamin K: {vitamin_k.x}")
        print(f"  Milligrams of Vitamin B6: {vitamin_b6.x}")
        print(f"  Objective Value: {m.objVal}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("Model is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
