
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_K")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B6")

# Objective function: Minimize 3*x0 + 6*x1
m.setObjective(3*x0 + 6*x1, GRB.MINIMIZE)

# Constraints:
# Digestive support index constraints
m.addConstr(9*x0 + 8*x1 >= 28, name="digestive_support_min")
m.addConstr(9*x0 + 8*x1 <= 57, name="digestive_support_max")

# Energy stability index constraints
m.addConstr(9*x0 + 20*x1 >= 13, name="energy_stability_min")
m.addConstr(9*x0 + 20*x1 <= 49, name="energy_stability_max")

# Cognitive performance index constraints
m.addConstr(11*x0 + 17*x1 >= 29, name="cognitive_performance_min")
m.addConstr(11*x0 + 17*x1 <= 59, name="cognitive_performance_max")

# Additional constraint
m.addConstr(-7*x0 + 9*x1 >= 0, name="additional_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of vitamin K: {x0.x}")
    print(f"Milligrams of vitamin B6: {x1.x}")
else:
    print("No optimal solution found.")
