
import gurobipy as gp

# Create a new model
model = gp.Model("Vitamin_Optimization")

# Define the variables
vitamin_K = model.addVar(name="vitamin_K", lb=0)  # Milligrams of vitamin K
vitamin_B6 = model.addVar(name="vitamin_B6", lb=0)  # Milligrams of vitamin B6

# Objective function: Minimize 3 * vitamin_K + 6 * vitamin_B6
model.setObjective(3 * vitamin_K + 6 * vitamin_B6, gp.GRB.MINIMIZE)

# Constraints
# Digestive support index for vitamin K and B6
model.addConstraint(9 * vitamin_K + 8 * vitamin_B6 >= 28, name="digestive_support_min")
model.addConstraint(9 * vitamin_K + 8 * vitamin_B6 <= 57, name="digestive_support_max")

# Energy stability index for vitamin K and B6
model.addConstraint(9 * vitamin_K + 20 * vitamin_B6 >= 13, name="energy_stability_min")
model.addConstraint(9 * vitamin_K + 20 * vitamin_B6 <= 49, name="energy_stability_max")

# Cognitive performance index for vitamin K and B6
model.addConstraint(11 * vitamin_K + 17 * vitamin_B6 >= 29, name="cognitive_performance_min")
model.addConstraint(11 * vitamin_K + 17 * vitamin_B6 <= 59, name="cognitive_performance_max")

# Additional constraint
model.addConstraint(-7 * vitamin_K + 9 * vitamin_B6 >= 0, name="additional_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin K: {vitamin_K.varValue}")
    print(f"Milligrams of vitamin B6: {vitamin_B6.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
