
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="CBRN_platoons")
x1 = m.addVar(vtype=GRB.INTEGER, name="artillery_batteries")
x2 = m.addVar(vtype=GRB.INTEGER, name="water_purification_units")
x3 = m.addVar(vtype=GRB.INTEGER, name="medical_platoons")

# Objective function
m.setObjective(4*x0**2 + 7*x0*x1 + 9*x0*x2 + 7*x0*x3 + 
               3*x1**2 + 2*x1*x2 + 8*x1*x3 + 
               5*x2*x3 + 5*x3**2 + 3*x0 + x2, GRB.MINIMIZE)

# Constraints
# Minimum logistics footprint constraints
m.addConstr(3*x0 + 2*x1 >= 11, name="logistics_min_1")
m.addConstr(2*x1 + 5*x2 >= 19, name="logistics_min_2")
m.addConstr(3*x0 + 5*x2 + 7*x3 >= 19, name="logistics_min_3")
m.addConstr(5*x2 + 7*x3 >= 17, name="logistics_min_4")

# Minimum fun factor constraints
m.addConstr(6*x0 + x1 >= 14, name="fun_min_1")
m.addConstr(6*x2 + 6*x3 >= 20, name="fun_min_2")
m.addConstr(6*x0 + x1 + 6*x2 + 6*x3 >= 20, name="fun_min_3")

# Maximum logistics footprint constraints
m.addConstr(3*x0 + 2*x1 <= 106, name="logistics_max_1")
m.addConstr(x1**2 + x3**2 <= 97, name="logistics_max_2")
m.addConstr(x1**2 + x2**2 <= 59, name="logistics_max_3")
m.addConstr(3*x0 + 5*x2 + 7*x3 <= 101, name="logistics_max_4")

# Non-negativity constraints (implied by variable definitions)

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"CBRN platoons: {x0.x}")
    print(f"Artillery batteries: {x1.x}")
    print(f"Water purification units: {x2.x}")
    print(f"Medical platoons: {x3.x}")
else:
    print("No optimal solution found")
