
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="CBRN_platoons", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="artillery_batteries", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="water_purification_units", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="medical_platoons", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(4*x0**2 + 7*x0*x1 + 9*x0*x2 + 7*x0*x3 + 3*x1**2 + 2*x1*x2 + 8*x1*x3 + 5*x2*x3 + 5*x3**2 + 3*x0 + x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x0 == 1)  # Given
    model.addConstr(5*x2 + 7*x3 >= 17)
    model.addConstr(3*x0 + 5*x2 >= 23)  
    model.addConstr(3*x0 + 2*x1 >= 11)
    model.addConstr(2*x1 + 5*x2 >= 19)
    model.addConstr(3*x0 + 2*x1 + 5*x2 + 7*x3 >= 19)
    model.addConstr(6*x0 + x1 >= 14)
    model.addConstr(6*x2 + 6*x3 >= 20)
    model.addConstr(6*x0 + x1 + 6*x2 + 6*x3 >= 20)
    model.addConstr(3*x0 + 2*x1 <= 106)
    model.addConstr(4*x1**2 + 49*x3**2 <= 97)
    model.addConstr(4*x1**2 + 25*x2**2 <= 59)
    model.addConstr(3*x0 + 5*x2 + 7*x3 <= 101)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("CBRN platoons: ", x0.varValue)
        print("Artillery batteries: ", x1.varValue)
        print("Water purification units: ", x2.varValue)
        print("Medical platoons: ", x3.varValue)
    else:
        print("No solution found")

optimize_problem()
