
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_A = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_A")
vitamin_B4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B4")
vitamin_B12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B12")

# Set objective function
m.setObjective(6.67 * vitamin_A + 8.69 * vitamin_B4 + 9.29 * vitamin_B12, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * vitamin_A + 10 * vitamin_B4 + 1 * vitamin_B12 <= 160, "kidney_support_index_limit") # Resource constraint r0
m.addConstr(14 * vitamin_A + 4 * vitamin_B4 + 13 * vitamin_B12 <= 109, "cognitive_performance_index_limit") # Resource constraint r1

m.addConstr(7 * vitamin_B4 - 8 * vitamin_B12 >= 0, "constraint_1")
m.addConstr(10 * vitamin_B4 + 1 * vitamin_B12 <= 139, "constraint_2")
m.addConstr(3 * vitamin_A + 1 * vitamin_B12 <= 127, "constraint_3")
m.addConstr(3 * vitamin_A + 10 * vitamin_B4 <= 96, "constraint_4")
m.addConstr(3 * vitamin_A + 10 * vitamin_B4 + 1 * vitamin_B12 <= 96, "constraint_5")
m.addConstr(14 * vitamin_A + 4 * vitamin_B4 <= 53, "constraint_6")
m.addConstr(4 * vitamin_B4 + 13 * vitamin_B12 <= 80, "constraint_7")
m.addConstr(14 * vitamin_A + 4 * vitamin_B4 + 13 * vitamin_B12 <= 70, "constraint_8")
m.addConstr(14 * vitamin_A + 4 * vitamin_B4 + 13 * vitamin_B12 <= 70, "constraint_9") # Redundant constraint, same as constraint_8


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Vitamin A: %g' % vitamin_A.x)
    print('Vitamin B4: %g' % vitamin_B4.x)
    print('Vitamin B12: %g' % vitamin_B12.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

