
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Labor Cost")

# Create variables
hank_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hank_hours")
jean_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="jean_hours")
mary_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="mary_hours")

# Set objective function
model.setObjective(6.35 * hank_hours + 4.82 * jean_hours + 7.75 * mary_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(5.9 * hank_hours + 20.41 * mary_hours >= 87, "c1")
model.addConstr(5.9 * hank_hours + 19.39 * jean_hours >= 61, "c2")
model.addConstr(5.9 * hank_hours + 19.39 * jean_hours + 20.41 * mary_hours >= 61, "c3")
model.addConstr(-10 * hank_hours + 6 * mary_hours >= 0, "c4")
model.addConstr(7 * jean_hours - 9 * mary_hours >= 0, "c5")
model.addConstr(5.9 * hank_hours + 19.39 * jean_hours <= 175, "c6")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal Solution:")
    print(f"Hank's hours: {hank_hours.x}")
    print(f"Jean's hours: {jean_hours.x}")
    print(f"Mary's hours: {mary_hours.x}")
    print(f"Objective Value: {model.objVal}")

