
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
hours_worked_by_Hank = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")
hours_worked_by_Jean = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Jean")
hours_worked_by_Mary = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Mary")

# Define the objective function
m.setObjective(6.35*hours_worked_by_Hank + 4.82*hours_worked_by_Jean + 7.75*hours_worked_by_Mary, GRB.MINIMIZE)

# Add constraints
m.addConstr(5.9*hours_worked_by_Hank + 20.41*hours_worked_by_Mary >= 87, name="organization_score_min_1")
m.addConstr(5.9*hours_worked_by_Hank + 19.39*hours_worked_by_Jean >= 61, name="organization_score_min_2")
m.addConstr(5.9*hours_worked_by_Hank + 19.39*hours_worked_by_Jean + 20.41*hours_worked_by_Mary >= 61, name="total_organization_score_min")
m.addConstr(-10*hours_worked_by_Hank + 6*hours_worked_by_Mary >= 0, name="hank_mary_constraint")
m.addConstr(7*hours_worked_by_Jean - 9*hours_worked_by_Mary >= 0, name="jean_mary_constraint")
m.addConstr(5.9*hours_worked_by_Hank + 19.39*hours_worked_by_Jean <= 175, name="organization_score_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Hank: {hours_worked_by_Hank.x}")
    print(f"Hours worked by Jean: {hours_worked_by_Jean.x}")
    print(f"Hours worked by Mary: {hours_worked_by_Mary.x}")
else:
    print("No optimal solution found")
