
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    H = model.addVar(name="H", lb=0)  # hours worked by Hank
    J = model.addVar(name="J", lb=0)  # hours worked by Jean
    M = model.addVar(name="M", lb=0)  # hours worked by Mary

    # Objective function: Minimize 6.35H + 4.82J + 7.75M
    model.setObjective(6.35 * H + 4.82 * J + 7.75 * M, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5.9 * H + 20.41 * M >= 87)  # Combined organization score from Hank and Mary
    model.addConstr(5.9 * H + 19.39 * J >= 61)  # Combined organization score from Hank and Jean
    model.addConstr(5.9 * H + 19.39 * J + 20.41 * M >= 61)  # Combined organization score from all
    model.addConstr(5.9 * H + 19.39 * J <= 175)  # Upper limit on combined organization score from Hank and Jean
    model.addConstr(-10 * H + 6 * M >= 0)  # Linear constraint involving Hank and Mary
    model.addConstr(7 * J - 9 * M >= 0)  # Linear constraint involving Jean and Mary

    # Update model
    model.update()

    # Solve the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Hank: {H.varValue}")
        print(f"Hours worked by Jean: {J.varValue}")
        print(f"Hours worked by Mary: {M.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
