
import gurobi as gp

# Define variables
J = gp.Var(name="hours_worked_by_Jean", lb=0)
M = gp.Var(name="hours_worked_by_Mary", lb=0, integrality=gp.GRB.INTEGER)
B = gp.Var(name="hours_worked_by_Bobby", lb=0)
D = gp.Var(name="hours_worked_by_Dale", lb=0, integrality=gp.GRB.INTEGER)
R = gp.Var(name="hours_worked_by_Ringo", lb=0)

# Objective function
model = gp.Model()
model.setObjective(1*J + 9*M + 3*B + 7*D + 2*R, gp.GRB.MAXIMIZE)

# Individual constraints
model.addConstr(3 * J <= 230)
model.addConstr(1 * J <= 191)
model.addConstr(8 * J <= 287)
model.addConstr(12 * J <= 223)

model.addConstr(18 * M <= 230)
model.addConstr(21 * M <= 191)
model.addConstr(13 * M <= 287)
model.addConstr(14 * M <= 223)

model.addConstr(18 * B <= 230)
model.addConstr(20 * B <= 191)
model.addConstr(1 * B <= 287)
model.addConstr(21 * B <= 223)

model.addConstr(21 * D <= 230)
model.addConstr(2 * D <= 191)
model.addConstr(5 * D <= 287)
model.addConstr(22 * D <= 223)

model.addConstr(5 * R <= 230)
model.addConstr(2 * R <= 191)
model.addConstr(7 * R <= 287)
model.addConstr(10 * R <= 223)

# Combined constraints
model.addConstr(18 * M + 21 * D + 5 * R >= 34)
model.addConstr(3 * J + 18 * B + 5 * R >= 34)
model.addConstr(3 * J + 21 * D + 5 * R >= 34)
model.addConstr(3 * J + 18 * M + 18 * B >= 34)

# Productivity constraints
model.addConstr(1 * J + 21 * M >= 21)
model.addConstr(2 * D + 2 * R >= 15)
model.addConstr(1 * J + 2 * R >= 36)

# Dollar cost constraints
model.addConstr(8 * J + 13 * M + 5 * D >= 42)

# Work quality constraints
model.addConstr(12 * J + 14 * M >= 42)
model.addConstr(12 * J + 10 * R >= 31)

# Upper bounds
model.addConstr(18 * M + 18 * B <= 214)
model.addConstr(18 * B + 5 * R <= 70)
model.addConstr(3 * J + 18 * M <= 88)

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Hours worked by Jean: ", J.varValue)
    print("Hours worked by Mary: ", M.varValue)
    print("Hours worked by Bobby: ", B.varValue)
    print("Hours worked by Dale: ", D.varValue)
    print("Hours worked by Ringo: ", R.varValue)
else:
    print("The model is infeasible")
