
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
paul_hours = m.addVar(lb=0, name="paul_hours")  # Non-integer hours allowed
dale_hours = m.addVar(lb=0, name="dale_hours")  # Non-integer hours allowed

# Set objective function
m.setObjective(3.56 * paul_hours + 9.21 * dale_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.44 * paul_hours + 0.93 * dale_hours >= 21, "paperwork_min")
m.addConstr(0.47 * paul_hours + 0.89 * dale_hours >= 12, "cost_min")
m.addConstr(8 * paul_hours - 5 * dale_hours >= 0, "hours_relation")
m.addConstr(0.44 * paul_hours + 0.93 * dale_hours <= 38, "paperwork_max") # Combined max paperwork constraint
m.addConstr(0.47 * paul_hours + 0.89 * dale_hours <= 21, "cost_max") # Combined max cost constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Paul's hours: {paul_hours.x}")
    print(f"  Dale's hours: {dale_hours.x}")
    print(f"  Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

