
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define decision variables
x0 = m.addVar(lb=0, name="hours_worked_by_Paul", vtype=GRB.CONTINUOUS)
x1 = m.addVar(lb=0, name="hours_worked_by_Dale", vtype=GRB.CONTINUOUS)

# Objective function: Maximize 3.56*x0 + 9.21*x1
m.setObjective(3.56*x0 + 9.21*x1, GRB.MAXIMIZE)

# Constraints
# 1. Total paperwork competence rating >= 21
m.addConstr(0.44*x0 + 0.93*x1 >= 21, name="paperwork_competence_min")

# 2. Total dollar cost per hour >= 12
m.addConstr(0.47*x0 + 0.89*x1 >= 12, name="dollar_cost_per_hour_min")

# 3. 8*x0 - 5*x1 >= 0
m.addConstr(8*x0 - 5*x1 >= 0, name="hours_constraint")

# 4 & 5. Total paperwork competence rating and dollar cost per hour have upper bounds
m.addConstr(0.44*x0 + 0.93*x1 <= 38, name="paperwork_competence_max")
m.addConstr(0.47*x0 + 0.89*x1 <= 21, name="dollar_cost_per_hour_max")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Paul: {x0.x}")
    print(f"Hours worked by Dale: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
