
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    hours_worked_by_paul = model.addVar(name="hours_worked_by_paul", lb=0)
    hours_worked_by_dale = model.addVar(name="hours_worked_by_dale", lb=0)

    # Define objective function
    model.setObjective(3.56 * hours_worked_by_paul + 9.21 * hours_worked_by_dale, gurobi.GRB.MAXIMIZE)

    # Define constraints
    model.addConstr(0.44 * hours_worked_by_paul + 0.93 * hours_worked_by_dale >= 21, name="paperwork_competence_rating_constraint")
    model.addConstr(0.47 * hours_worked_by_paul + 0.89 * hours_worked_by_dale >= 12, name="dollar_cost_per_hour_constraint")
    model.addConstr(8 * hours_worked_by_paul - 5 * hours_worked_by_dale >= 0, name="linear_constraint")
    model.addConstr(0.44 * hours_worked_by_paul + 0.93 * hours_worked_by_dale <= 38, name="upper_bound_paperwork_competence_rating_constraint")
    model.addConstr(0.47 * hours_worked_by_paul + 0.89 * hours_worked_by_dale <= 21, name="upper_bound_dollar_cost_per_hour_constraint")

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Paul: {hours_worked_by_paul.varValue}")
        print(f"Hours worked by Dale: {hours_worked_by_dale.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
