
import gurobipy as gp

# Create a new model
m = gp.Model("WorkHourOptimization")

# Create variables
paul_hours = m.addVar(vtype=gp.GRB.INTEGER, name="paul_hours")
dale_hours = m.addVar(vtype=gp.GRB.INTEGER, name="dale_hours")
john_hours = m.addVar(vtype=gp.GRB.CONTINUOUS, name="john_hours")
hank_hours = m.addVar(vtype=gp.GRB.INTEGER, name="hank_hours")
mary_hours = m.addVar(vtype=gp.GRB.INTEGER, name="mary_hours")

# Set objective function
m.setObjective(1.7 * paul_hours + 4.03 * dale_hours + 4.91 * john_hours + 3.04 * hank_hours + 1.33 * mary_hours, gp.GRB.MAXIMIZE)

# Add constraints - Dollar cost per hour
m.addConstr(6 * john_hours + 14 * mary_hours >= 20)
m.addConstr(12 * dale_hours + 6 * john_hours + 2 * hank_hours >= 32)
m.addConstr(6 * john_hours + 2 * hank_hours + 14 * mary_hours >= 32)
m.addConstr(11 * paul_hours + 12 * dale_hours + 6 * john_hours >= 32)
m.addConstr(11 * paul_hours + 6 * john_hours + 14 * mary_hours >= 32)
m.addConstr(12 * dale_hours + 6 * john_hours + 14 * mary_hours >= 32)
m.addConstr(11 * paul_hours + 12 * dale_hours + 2 * hank_hours >= 32)
m.addConstr(12 * dale_hours + 6 * john_hours + 2 * hank_hours >= 36)
m.addConstr(6 * john_hours + 2 * hank_hours + 14 * mary_hours >= 36)
m.addConstr(11 * paul_hours + 12 * dale_hours + 6 * john_hours >= 36)
m.addConstr(11 * paul_hours + 6 * john_hours + 14 * mary_hours >= 36)
m.addConstr(12 * dale_hours + 6 * john_hours + 14 * mary_hours >= 36)
m.addConstr(11 * paul_hours + 12 * dale_hours + 2 * hank_hours >= 36)
m.addConstr(12 * dale_hours + 6 * john_hours + 2 * hank_hours >= 41)
m.addConstr(6 * john_hours + 2 * hank_hours + 14 * mary_hours >= 41)
m.addConstr(11 * paul_hours + 12 * dale_hours + 6 * john_hours >= 41)
m.addConstr(11 * paul_hours + 6 * john_hours + 14 * mary_hours >= 41)
m.addConstr(12 * dale_hours + 6 * john_hours + 14 * mary_hours >= 41)
m.addConstr(11 * paul_hours + 12 * dale_hours + 2 * hank_hours >= 41)
m.addConstr(12 * dale_hours + 6 * john_hours + 2 * hank_hours >= 52)
m.addConstr(6 * john_hours + 2 * hank_hours + 14 * mary_hours >= 52)
m.addConstr(11 * paul_hours + 12 * dale_hours + 6 * john_hours >= 52)
m.addConstr(11 * paul_hours + 6 * john_hours + 14 * mary_hours >= 52)
m.addConstr(12 * dale_hours + 6 * john_hours + 14 * mary_hours >= 52)
m.addConstr(11 * paul_hours + 12 * dale_hours + 2 * hank_hours >= 52)
m.addConstr(12 * dale_hours + 6 * john_hours + 2 * hank_hours >= 51)
m.addConstr(6 * john_hours + 2 * hank_hours + 14 * mary_hours >= 51)
m.addConstr(11 * paul_hours + 12 * dale_hours + 6 * john_hours >= 51)
m.addConstr(11 * paul_hours + 6 * john_hours + 14 * mary_hours >= 51)
m.addConstr(12 * dale_hours + 6 * john_hours + 14 * mary_hours >= 51)
m.addConstr(11 * paul_hours + 12 * dale_hours + 2 * hank_hours >= 51)
m.addConstr(12 * dale_hours + 6 * john_hours + 2 * hank_hours >= 55)
m.addConstr(6 * john_hours + 2 * hank_hours + 14 * mary_hours >= 55)
m.addConstr(11 * paul_hours + 12 * dale_hours + 6 * john_hours >= 55)
m.addConstr(11 * paul_hours + 6 * john_hours + 14 * mary_hours >= 55)
m.addConstr(12 * dale_hours + 6 * john_hours + 14 * mary_hours >= 55)
m.addConstr(11 * paul_hours + 12 * dale_hours + 2 * hank_hours >= 55)


# Add constraints - Productivity rating
m.addConstr(12 * paul_hours + 16 * john_hours >= 32)
m.addConstr(18 * dale_hours + 16 * john_hours >= 56)
m.addConstr(18 * dale_hours + 10 * mary_hours >= 54)
m.addConstr(19 * hank_hours + 10 * mary_hours >= 29)
m.addConstr(16 * john_hours + 19 * hank_hours >= 60)
m.addConstr(12 * paul_hours + 10 * mary_hours >= 38)
m.addConstr(16 * john_hours + 10 * mary_hours >= 25)
m.addConstr(18 * dale_hours + 19 * hank_hours >= 57)
m.addConstr(12 * paul_hours + 18 * dale_hours >= 31)
m.addConstr(12 * paul_hours + 19 * hank_hours >= 30)
m.addConstr(12 * paul_hours + 18 * dale_hours + 19 * hank_hours >= 32)
m.addConstr(18 * dale_hours + 19 * hank_hours + 10 * mary_hours >= 32)
m.addConstr(12 * paul_hours + 19 * hank_hours + 10 * mary_hours >= 32)
m.addConstr(12 * paul_hours + 18 * dale_hours + 19 * hank_hours >= 32)
m.addConstr(18 * dale_hours + 19 * hank_hours + 10 * mary_hours >= 32)
m.addConstr(12 * paul_hours + 19 * hank_hours + 10 * mary_hours >= 32)
m.addConstr(12 * paul_hours + 18 * dale_hours + 19 * hank_hours >= 45)
m.addConstr(18 * dale_hours + 19 * hank_hours + 10 * mary_hours >= 45)
m.addConstr(12 * paul_hours + 19 * hank_hours + 10 * mary_hours >= 45)


# Add constraints - Likelihood to quit index
m.addConstr(9 * paul_hours + 13 * john_hours >= 15)
m.addConstr(4 * dale_hours + 3 * mary_hours >= 19)
m.addConstr(9 * paul_hours + 6 * hank_hours >= 21)
m.addConstr(9 * paul_hours + 3 * mary_hours >= 17)
m.addConstr(4 * dale_hours + 13 * john_hours >= 18)
m.addConstr(13 * john_hours + 6 * hank_hours >= 8)
m.addConstr(9 * paul_hours + 6 * hank_hours + 3 * mary_hours >= 22)

# Add constraints - Upper bounds for combined resources (dollar cost per hour)
m.addConstr(11 * paul_hours + 6 * john_hours <= 310)
m.addConstr(6 * john_hours + 2 * hank_hours <= 135)
m.addConstr(11 * paul_hours + 14 * mary_hours <= 263)
m.addConstr(12 * dale_hours + 14 * mary_hours <= 295)
m.addConstr(11 * paul_hours + 2 * hank_hours <= 159)
m.addConstr(11 * paul_hours + 12 * dale_hours + 6 * john_hours <= 86)
m.addConstr(11 * paul_hours + 12 * dale_hours + 14 * mary_hours <= 258)
m.addConstr(6 * john_hours + 2 * hank_hours + 14 * mary_hours <= 131)
m.addConstr(12 * dale_hours + 6 * john_hours + 14 * mary_hours <= 305)
m.addConstr(12 * dale_hours + 2 * hank_hours + 14 * mary_hours <= 213)
m.addConstr(11 * paul_hours + 12 * dale_hours + 6 * john_hours + 2 * hank_hours + 14 * mary_hours <= 213)

# Add constraints - Upper bounds for combined resources (productivity rating)
m.addConstr(12 * paul_hours + 19 * hank_hours <= 251)
m.addConstr(12 * paul_hours + 10 * mary_hours <= 118)
m.addConstr(18 * dale_hours + 19 * hank_hours <= 217)
m.addConstr(12 * paul_hours + 18 * dale_hours <= 140)
m.addConstr(16 * john_hours + 19 * hank_hours <= 138)
m.addConstr(16 * john_hours + 10 * mary_hours <= 83)
m.addConstr(18 * dale_hours + 16 * john_hours <= 146)
m.addConstr(12 * paul_hours + 18 * dale_hours + 16 * john_hours + 19 * hank_hours + 10 * mary_hours <= 146)

# Add constraints - Upper bounds for combined resources (likelihood to quit index)
m.addConstr(4 * dale_hours + 6 * hank_hours <= 27)
m.addConstr(9 * paul_hours + 3 * mary_hours <= 60)
m.addConstr(6 * hank_hours + 3 * mary_hours <= 52)
m.addConstr(9 * paul_hours + 4 * dale_hours + 13 * john_hours + 6 * hank_hours + 3 * mary_hours <= 52)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)
