
import gurobi as gp

# Create a new Gurobi model
m = gp.Model()

# Define the variables
P = m.addVar(name="P", vtype=gp.GRB.INTEGER)
D = m.addVar(name="D", vtype=gp.GRB.INTEGER)
J = m.addVar(name="J")
H = m.addVar(name="H", vtype=gp.GRB.INTEGER)
M = m.addVar(name="M", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(1.7 * P + 4.03 * D + 4.91 * J + 3.04 * H + 1.33 * M, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11 * P + 12 * D + 6 * J + 2 * H + 14 * M <= 312)
m.addConstr(12 * P + 18 * D + 16 * J + 19 * H + 10 * M <= 323)
m.addConstr(9 * P + 4 * D + 13 * J + 6 * H + 3 * M <= 117)

# ... add all other constraints ...

# Add constraints for costs
m.addConstr(11 * P <= 11)
m.addConstr(12 * D <= 12)
m.addConstr(6 * J <= 6)
m.addConstr(2 * H <= 2)
m.addConstr(14 * M <= 14)

m.addConstr(6 * J + 14 * M >= 20)
m.addConstr(12 * D + 6 * J + 2 * H >= 32)
m.addConstr(6 * J + 2 * H + 14 * M >= 32)
m.addConstr(11 * P + 12 * D + 6 * J >= 32)

# ... add all other constraints ...

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("P: ", P.varValue)
    print("D: ", D.varValue)
    print("J: ", J.varValue)
    print("H: ", H.varValue)
    print("M: ", M.varValue)
else:
    print("No solution found")
