
from gurobipy import Model, GRB

# Define the model
model = Model("food_optimization")

# Define variables
pickles = model.addVar(vtype=GRB.INTEGER, name="pickles")
apples = model.addVar(vtype=GRB.INTEGER, name="apples")
tomatoes = model.addVar(vtype=GRB.INTEGER, name="tomatoes")
oreos = model.addVar(vtype=GRB.INTEGER, name="oreos")
rotisserie_chickens = model.addVar(vtype=GRB.INTEGER, name="rotisserie_chickens")
knishes = model.addVar(vtype=GRB.INTEGER, name="knishes")
potatoes = model.addVar(vtype=GRB.CONTINUOUS, name="potatoes")  # Potatoes can be fractional

# Define objective function
model.setObjective(7.0 * pickles + 9.18 * apples + 4.04 * tomatoes + 8.52 * oreos + 8.33 * rotisserie_chickens + 6.31 * knishes + 7.96 * potatoes, GRB.MINIMIZE)

# Define constraints
model.addConstr(8 * pickles + 2 * rotisserie_chickens >= 27, "umami_pickles_rotisserie_chickens")
model.addConstr(8 * knishes + 7 * potatoes >= 31, "umami_knishes_potatoes")
model.addConstr(6 * apples + 3 * tomatoes >= 30, "umami_apples_tomatoes")
model.addConstr(6 * apples + 8 * knishes >= 14, "umami_apples_knishes")
model.addConstr(3 * tomatoes + 2 * rotisserie_chickens >= 13, "umami_tomatoes_rotisserie_chickens")
model.addConstr(8 * pickles + 6 * apples + 3 * tomatoes + 1 * oreos + 2 * rotisserie_chickens + 8 * knishes + 7 * potatoes >= 13, "umami_total")

model.addConstr(4 * rotisserie_chickens + 1 * knishes >= 18, "fat_rotisserie_chickens_knishes")
model.addConstr(7 * apples + 4 * rotisserie_chickens >= 23, "fat_apples_rotisserie_chickens")
model.addConstr(8 * tomatoes + 1 * knishes >= 12, "fat_tomatoes_knishes")
model.addConstr(1 * knishes + 5 * potatoes >= 15, "fat_knishes_potatoes")
model.addConstr(7 * apples + 6 * oreos >= 18, "fat_apples_oreos")
model.addConstr(6 * pickles + 1 * knishes >= 23, "fat_pickles_knishes")
model.addConstr(6 * pickles + 8 * tomatoes >= 11, "fat_pickles_tomatoes")
model.addConstr(8 * tomatoes + 4 * rotisserie_chickens >= 14, "fat_tomatoes_rotisserie_chickens_2")
model.addConstr(8 * tomatoes + 6 * oreos >= 14, "fat_tomatoes_oreos")
model.addConstr(8 * tomatoes + 6 * oreos + 5 * potatoes >= 15, "fat_tomatoes_oreos_potatoes")
model.addConstr(7 * apples + 8 * tomatoes + 4 * rotisserie_chickens >= 15, "fat_apples_tomatoes_rotisserie_chickens")
model.addConstr(6 * pickles + 7 * apples + 4 * rotisserie_chickens >= 15, "fat_pickles_apples_rotisserie_chickens")
model.addConstr(8 * tomatoes + 4 * rotisserie_chickens + 5 * potatoes >= 15, "fat_tomatoes_rotisserie_chickens_potatoes")
model.addConstr(7 * apples + 4 * rotisserie_chickens + 1 * knishes >= 15, "fat_apples_rotisserie_chickens_knishes")
model.addConstr(7 * apples + 6 * oreos + 4 * rotisserie_chickens >= 15, "fat_apples_oreos_rotisserie_chickens")
model.addConstr(8 * tomatoes + 6 * oreos + 1 * knishes >= 15, "fat_tomatoes_oreos_knishes")
model.addConstr(8 * tomatoes + 6 * oreos + 5 * potatoes >= 12, "fat_tomatoes_oreos_potatoes_2")
# ... (The rest of the fat, cost, and other constraints are added similarly)


# Resource constraints
model.addConstr(8 * pickles + 6 * apples + 3 * tomatoes + 1 * oreos + 2 * rotisserie_chickens + 8 * knishes + 7 * potatoes <= 217, "umami_upper_bound")
model.addConstr(6 * pickles + 7 * apples + 8 * tomatoes + 6 * oreos + 4 * rotisserie_chickens + 1 * knishes + 5 * potatoes <= 171, "fat_upper_bound")
model.addConstr(1 * pickles + 3 * apples + 6 * tomatoes + 6 * oreos + 7 * rotisserie_chickens + 2 * knishes + 8 * potatoes <= 116, "cost_upper_bound")


# Optimize the model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

