
import gurobi as gp

# Define the variables
m = gp.Model("optimization_problem")

pickles = m.addVar(name="pickles", vtype=gp.GRB.INTEGER)
apples = m.addVar(name="apples", vtype=gp.GRB.INTEGER)
tomatoes = m.addVar(name="tomatoes", vtype=gp.GRB.INTEGER)
oreos = m.addVar(name="oreos", vtype=gp.GRB.INTEGER)
rotisserie_chickens = m.addVar(name="rotisserie_chickens", vtype=gp.GRB.INTEGER)
knishes = m.addVar(name="knishes", vtype=gp.GRB.INTEGER)
potatoes = m.addVar(name="potatoes")

# Define the objective function
m.setObjective(7.0 * pickles + 9.18 * apples + 4.04 * tomatoes + 8.52 * oreos + 
               8.33 * rotisserie_chickens + 6.31 * knishes + 7.96 * potatoes, gp.GRB.MINIMIZE)

# Define the constraints
# Umami index constraints
m.addConstr(8 * pickles + 2 * rotisserie_chickens >= 27)
m.addConstr(8 * knishes + 7 * potatoes >= 31)
m.addConstr(6 * apples + 3 * tomatoes >= 30)
m.addConstr(6 * apples + 8 * knishes >= 14)
m.addConstr(3 * tomatoes + 2 * rotisserie_chickens >= 13)
m.addConstr(8 * pickles + 6 * apples + 3 * tomatoes + oreos + 2 * rotisserie_chickens + 8 * knishes + 7 * potatoes >= 13)

# Fat constraints
m.addConstr(6 * rotisserie_chickens + knishes >= 18)
m.addConstr(7 * apples + 4 * rotisserie_chickens >= 23)
m.addConstr(8 * tomatoes + knishes >= 12)
m.addConstr(knishes + 5 * potatoes >= 15)
m.addConstr(7 * apples + 6 * oreos >= 18)
m.addConstr(6 * pickles + knishes >= 23)
m.addConstr(6 * pickles + 8 * tomatoes >= 11)
m.addConstr(8 * tomatoes + 4 * rotisserie_chickens >= 14)
m.addConstr(6 * tomatoes + 6 * oreos >= 14)
m.addConstr(8 * tomatoes + 6 * oreos + 5 * potatoes >= 15)
m.addConstr(7 * apples + 8 * tomatoes + 4 * rotisserie_chickens >= 15)
m.addConstr(6 * pickles + 7 * apples + 4 * rotisserie_chickens >= 15)
m.addConstr(8 * tomatoes + 4 * rotisserie_chickens + 5 * potatoes >= 15)
m.addConstr(7 * apples + 4 * rotisserie_chickens + knishes >= 15)
m.addConstr(7 * apples + 6 * oreos + 4 * rotisserie_chickens >= 15)
m.addConstr(8 * tomatoes + 6 * oreos + knishes >= 15)
m.addConstr(8 * tomatoes + 6 * oreos + 5 * potatoes >= 12)

# Cost constraints
m.addConstr(6 * oreos + 8 * potatoes >= 10)
m.addConstr(pickles + 6 * oreos >= 11)
m.addConstr(pickles + 2 * knishes >= 5)
m.addConstr(6 * tomatoes + 6 * oreos >= 6)
m.addConstr(3 * apples + 6 * oreos >= 16)
m.addConstr(pickles + 8 * potatoes >= 6)
m.addConstr(6 * tomatoes + 2 * knishes >= 6)
m.addConstr(7 * rotisserie_chickens + 2 * knishes >= 11)
m.addConstr(6 * oreos + 7 * rotisserie_chickens >= 12)
m.addConstr(6 * oreos + 2 * knishes >= 5)
m.addConstr(pickles + 6 * tomatoes >= 14)
m.addConstr(2 * knishes + 8 * potatoes >= 11)
m.addConstr(pickles + 7 * rotisserie_chickens >= 10)
m.addConstr(pickles + 3 * apples >= 5)
m.addConstr(pickles + 3 * apples + 6 * tomatoes + oreos + 7 * rotisserie_chickens + 2 * knishes + 8 * potatoes >= 5)

# Linear constraints
m.addConstr(3 * tomatoes - 8 * potatoes >= 0)
m.addConstr(4 * apples - 10 * tomatoes >= 0)

# Umami index upper bounds
m.addConstr(3 * tomatoes + 7 * potatoes <= 31)
m.addConstr(6 * apples + 2 * rotisserie_chickens + 7 * potatoes <= 171)
m.addConstr(3 * tomatoes + oreos + 2 * knishes <= 117)
m.addConstr(8 * pickles + 6 * apples + 3 * tomatoes <= 209)

# Fat upper bounds
m.addConstr(6 * pickles + 7 * apples + 4 * rotisserie_chickens <= 168)
m.addConstr(pickles + 6 * oreos + 8 * potatoes <= 89)
m.addConstr(6 * pickles + 8 * tomatoes + 2 * knishes <= 145)
m.addConstr(6 * pickles + 7 * apples + 2 * knishes <= 82)
m.addConstr(6 * oreos + 4 * rotisserie_chickens + 5 * potatoes <= 149)
m.addConstr(7 * apples + 8 * tomatoes + 2 * knishes <= 105)
m.addConstr(8 * tomatoes + 6 * oreos + 5 * potatoes <= 105)
m.addConstr(6 * pickles + 7 * apples + 8 * potatoes <= 28)
m.addConstr(6 * oreos + 2 * knishes + 8 * potatoes <= 135)

# Cost upper bounds
m.addConstr(3 * apples + 7 * rotisserie_chickens <= 19)
m.addConstr(7 * rotisserie_chickens + 2 * knishes <= 24)
m.addConstr(3 * apples + 6 * tomatoes + 6 * oreos <= 69)
m.addConstr(6 * oreos + 2 * knishes + 8 * potatoes <= 74)
m.addConstr(pickles + 6 * oreos + 8 * potatoes <= 57)
m.addConstr(3 * apples + 6 * oreos + 8 * potatoes <= 51)
m.addConstr(3 * apples + 6 * tomatoes + 7 * rotisserie_chickens <= 68)
m.addConstr(pickles + 2 * knishes + 8 * potatoes <= 74)
m.addConstr(pickles + 6 * tomatoes + 2 * knishes <= 74)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Pickles: ", pickles.varValue)
    print("Apples: ", apples.varValue)
    print("Tomatoes: ", tomatoes.varValue)
    print("Oreos: ", oreos.varValue)
    print("Rotisserie Chickens: ", rotisserie_chickens.varValue)
    print("Knishes: ", knishes.varValue)
    print("Potatoes: ", potatoes.varValue)
else:
    print("The model is infeasible.")
