
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
ringo = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")
mary = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")
jean = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
dale = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")
john = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john")
bill = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")

# Set objective function
model.setObjective(4.87 * ringo + 3.0 * mary + 9.03 * jean + 7.73 * dale + 8.75 * john + 7.94 * bill, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(7 * ringo + 11 * mary + 5 * jean + 6 * dale + 6 * john + 9 * bill <= 123, "c0") # paperwork competence rating
model.addConstr(5 * ringo + 9 * mary + 9 * jean + 6 * dale + 10 * john + 8 * bill <= 160, "c1") # organization score

model.addConstr(6 * dale + 6 * john >= 18, "c2")
model.addConstr(11 * mary + 6 * dale >= 17, "c3")
model.addConstr(11 * mary + 6 * john >= 13, "c4")
model.addConstr(7 * ringo + 5 * jean >= 19, "c5")
model.addConstr(7 * ringo + 6 * dale >= 15, "c6")
model.addConstr(11 * mary + 9 * bill >= 9, "c7")
model.addConstr(6 * john + 9 * bill >= 8, "c8")
model.addConstr(6 * dale + 9 * bill >= 10, "c9")
model.addConstr(7 * ringo + 9 * bill >= 8, "c10")
model.addConstr(7 * ringo + 5 * jean + 6 * john >= 15, "c11")
model.addConstr(7 * ringo + 11 * mary + 9 * bill >= 15, "c12")
model.addConstr(7 * ringo + 6 * john + 9 * bill >= 15, "c13")
model.addConstr(7 * ringo + 5 * jean + 6 * john >= 16, "c14")
model.addConstr(7 * ringo + 11 * mary + 9 * bill >= 16, "c15")
model.addConstr(7 * ringo + 6 * john + 9 * bill >= 16, "c16")
model.addConstr(7 * ringo + 5 * jean + 6 * john >= 20, "c17")
model.addConstr(7 * ringo + 11 * mary + 9 * bill >= 20, "c18")
model.addConstr(7 * ringo + 6 * john + 9 * bill >= 20, "c19")


#Organization Score Constraints (Simplified to avoid redundancy)
model.addConstr(5 * ringo + 9 * mary >= 25, "c20")
model.addConstr(9 * mary + 8 * bill >= 14, "c21")
model.addConstr(9 * mary + 9 * jean >= 23, "c22")
model.addConstr(9 * jean + 10 * john >= 18, "c23")
model.addConstr(9 * jean + 10 * john + 8 * bill >= 24, "c24") #Most restrictive
model.addConstr(5 * ringo + 9 * mary + 6 * dale >= 24, "c25") #Most restrictive
model.addConstr(9 * mary + 9 * jean + 6 * dale >= 24, "c26") #Most restrictive
model.addConstr(9 * mary + 6 * dale + 10 * john >= 24, "c27") #Most restrictive
model.addConstr(5 * ringo + 10 * john + 8 * bill >= 24, "c28") #Most restrictive
model.addConstr(5 * ringo + 9 * mary + 8 * bill >= 24, "c29") #Most restrictive
model.addConstr(5 * ringo + 9 * mary + 10 * john >= 24, "c30") #Most restrictive
model.addConstr(5 * ringo + 6 * dale + 8 * bill >= 24, "c31") #Most restrictive
model.addConstr(9 * jean + 6 * dale + 8 * bill >= 24, "c32") #Most restrictive
model.addConstr(9 * mary + 9 * jean + 8 * bill >= 24, "c33") #Most restrictive
model.addConstr(5 * ringo + 9 * jean + 6 * dale >= 24, "c34") #Most restrictive
model.addConstr(5 * ringo + 9 * mary + 9 * jean >= 24, "c35") #Most restrictive
model.addConstr(6 * dale + 10 * john + 8 * bill >= 24, "c36") #Most restrictive
model.addConstr(9 * jean + 6 * dale + 10 * john >= 24, "c37") #Most restrictive
model.addConstr(5 * ringo + 6 * dale + 10 * john >= 24, "c38") #Most restrictive


#Paperwork competence rating upper bounds (Simplified to avoid redundancy)
model.addConstr(11 * mary + 6 * dale <= 33, "c39")
model.addConstr(11 * mary + 6 * john <= 50, "c40")
model.addConstr(7 * ringo + 6 * dale + 6 * john <= 87, "c41")
model.addConstr(7 * ringo + 5 * jean + 6 * john <= 55, "c42")
model.addConstr(7 * ringo + 11 * mary + 6 * dale <= 119, "c43")
model.addConstr(7 * ringo + 11 * mary + 5 * jean <= 116, "c44")
model.addConstr(11 * mary + 6 * dale + 6 * john <= 67, "c45")
model.addConstr(7 * ringo + 6 * john + 9 * bill <= 91, "c46")
model.addConstr(11 * mary + 5 * jean + 6 * dale <= 69, "c47")
model.addConstr(5 * jean + 6 * dale + 6 * john <= 30, "c48")
model.addConstr(5 * jean + 6 * dale + 9 * bill <= 91, "c49")
model.addConstr(7 * ringo + 5 * jean + 9 * bill <= 52, "c50")
model.addConstr(11 * mary + 5 * jean + 9 * bill <= 65, "c51")
model.addConstr(6 * dale + 6 * john + 9 * bill <= 110, "c52")
model.addConstr(11 * mary + 6 * dale + 9 * bill <= 21, "c53")
model.addConstr(7 * ringo + 11 * mary + 5 * jean + 6 * dale + 6 * john + 9 * bill <= 21, "c54")

#Organization Score upper bounds (Simplified to avoid redundancy)
model.addConstr(5 * ringo + 8 * bill <= 69, "c55")
model.addConstr(9 * jean + 8 * bill <= 33, "c56")
model.addConstr(9 * jean + 6 * dale <= 77, "c57")
model.addConstr(9 * mary + 6 * dale <= 88, "c58")
model.addConstr(6 * dale + 8 * bill <= 111, "c59")
model.addConstr(5 * ringo + 9 * mary + 6 * dale <= 61, "c60")
model.addConstr(9 * mary + 6 * dale + 10 * john <= 106, "c61")
model.addConstr(9 * mary + 9 * jean + 6 * dale <= 142, "c62")
model.addConstr(5 * ringo + 9 * mary + 9 * jean <= 69, "c63")
model.addConstr(9 * mary + 9 * jean + 10 * john <= 44, "c64")
model.addConstr(5 * ringo + 10 * john + 8 * bill <= 56, "c65")
model.addConstr(5 * ringo + 9 * mary + 9 * jean + 6 * dale + 10 * john + 8 * bill <= 56, "c66")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("The model could not be solved to optimality.")

