
from gurobipy import *

# Create a model
m = Model("Work Hours")

# Define variables
Ringo = m.addVar(name="Ringo", lb=0, ub=GRB.INFINITY)
Mary = m.addVar(name="Mary", lb=0, ub=GRB.INFINITY)
Jean = m.addVar(name="Jean", lb=0, ub=GRB.INFINITY)
Dale = m.addVar(name="Dale", lb=0, ub=GRB.INFINITY)
John = m.addVar(name="John", lb=0, ub=GRB.INFINITY)
Bill = m.addVar(name="Bill", lb=0, ub=GRB.INFINITY)

# Define constraints
m.addConstr(Ringo + Mary >= 25, name="Ringo_Mary")
m.addConstr(Jean + Dale >= 30, name="Jean_Dale")
m.addConstr(John + Bill >= 20, name="John_Bill")

# Add more constraints based on the problem description
m.addConstr(Ringo + Mary + Jean <= 69, name="Total_Rating_1")
m.addConstr(Jean + Bill <= 33, name="Jean_Bill")
m.addConstr(Jean + Dale <= 77, name="Jean_Dale")
m.addConstr(Mary + Dale <= 88, name="Mary_Dale")
m.addConstr(Dale + Bill <= 111, name="Dale_Bill")

# Add constraints for organization scores
m.addConstr(Ringo + Mary + Jean + Dale <= 142, name="Org_Score_1")
m.addConstr(Mary + Jean + John <= 44, name="Org_Score_2")
m.addConstr(Ringo + John + Bill <= 56, name="Org_Score_3")

# Add constraints for paperwork competence ratings
m.addConstr(Ringo + Mary + Dale <= 119, name="Paper_Rating_1")
m.addConstr(Ringo + Mary + Jean <= 116, name="Paper_Rating_2")
m.addConstr(Mary + Dale + John <= 67, name="Paper_Rating_3")

# Objective function
m.setObjective(Ringo + Mary + Jean + Dale + John + Bill, GRB.MINIMIZE)

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Obj:", m.objVal)
