
from gurobipy import Model, GRB

# Create a new model
model = Model("Nutrition_Optimization")

# Create variables
magnesium = model.addVar(vtype=GRB.INTEGER, name="magnesium")
vitamin_b5 = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b5")
carbohydrates = model.addVar(vtype=GRB.CONTINUOUS, name="carbohydrates")
vitamin_b2 = model.addVar(vtype=GRB.INTEGER, name="vitamin_b2")

# Set objective function
model.setObjective(7.73 * magnesium + 6.54 * vitamin_b5 + 9.04 * carbohydrates + 9.4 * vitamin_b2, GRB.MINIMIZE)

# Add constraints
model.addConstr(6 * magnesium + 14 * vitamin_b5 + 4 * carbohydrates + 10 * vitamin_b2 <= 126, "c0") # Cognitive performance index
model.addConstr(20 * magnesium + 14 * vitamin_b5 + 22 * carbohydrates + 13 * vitamin_b2 <= 273, "c1") # Energy stability index

model.addConstr(4 * carbohydrates + 10 * vitamin_b2 >= 26, "c2")
model.addConstr(14 * vitamin_b5 + 4 * carbohydrates >= 15, "c3")
model.addConstr(14 * vitamin_b5 + 10 * vitamin_b2 >= 25, "c4")
model.addConstr(6 * magnesium + 4 * carbohydrates >= 27, "c5")
model.addConstr(6 * magnesium + 14 * vitamin_b5 + 4 * carbohydrates + 10 * vitamin_b2 >= 27, "c6")

model.addConstr(20 * magnesium + 14 * vitamin_b5 >= 33, "c7")
model.addConstr(20 * magnesium + 22 * carbohydrates >= 59, "c8")
model.addConstr(14 * vitamin_b5 + 22 * carbohydrates >= 47, "c9")
model.addConstr(14 * vitamin_b5 + 13 * vitamin_b2 >= 31, "c10")
model.addConstr(20 * magnesium + 22 * carbohydrates + 13 * vitamin_b2 >= 53, "c11")
model.addConstr(20 * magnesium + 14 * vitamin_b5 + 22 * carbohydrates + 13 * vitamin_b2 >= 53, "c12")

model.addConstr(-3 * carbohydrates + 2 * vitamin_b2 >= 0, "c13")
model.addConstr(14 * vitamin_b5 + 22 * carbohydrates <= 219, "c14")
model.addConstr(20 * magnesium + 22 * carbohydrates <= 116, "c15")
model.addConstr(14 * vitamin_b5 + 13 * vitamin_b2 <= 168, "c16")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('magnesium:', magnesium.x)
    print('vitamin_b5:', vitamin_b5.x)
    print('carbohydrates:', carbohydrates.x)
    print('vitamin_b2:', vitamin_b2.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

