
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="milligrams_of_magnesium", vtype=gp.GRB.INTEGER)  # integer
x1 = m.addVar(name="milligrams_of_vitamin_B5", vtype=gp.GRB.CONTINUOUS)  # continuous
x2 = m.addVar(name="grams_of_carbohydrates", vtype=gp.GRB.CONTINUOUS)  # continuous
x3 = m.addVar(name="milligrams_of_vitamin_B2", vtype=gp.GRB.INTEGER)  # integer

# Objective function
m.setObjective(7.73 * x0 + 6.54 * x1 + 9.04 * x2 + 9.4 * x3, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(6 * x0 <= 126, name="cognitive_performance_magnesium")
m.addConstr(20 * x0 <= 273, name="energy_stability_magnesium")
m.addConstr(14 * x1 <= 126, name="cognitive_performance_vitamin_B5")
m.addConstr(14 * x1 <= 273, name="energy_stability_vitamin_B5")
m.addConstr(4 * x2 <= 126, name="cognitive_performance_carbohydrates")
m.addConstr(22 * x2 <= 273, name="energy_stability_carbohydrates")
m.addConstr(10 * x3 <= 126, name="cognitive_performance_vitamin_B2")
m.addConstr(13 * x3 <= 273, name="energy_stability_vitamin_B2")

m.addConstr(4 * x2 + 10 * x3 >= 26, name="combined_cognitive_performance_B2_carbohydrates")
m.addConstr(14 * x1 + 4 * x2 >= 15, name="combined_cognitive_performance_vitamin_B5_carbohydrates")
m.addConstr(14 * x1 + 10 * x3 >= 25, name="combined_cognitive_performance_vitamin_B5_B2")
m.addConstr(6 * x0 + 4 * x2 >= 27, name="combined_cognitive_performance_magnesium_carbohydrates")
m.addConstr(6 * x0 + 14 * x1 + 4 * x2 + 10 * x3 >= 27, name="combined_cognitive_performance_all")

m.addConstr(20 * x0 + 14 * x1 >= 33, name="combined_energy_stability_magnesium_vitamin_B5")
m.addConstr(20 * x0 + 22 * x2 >= 59, name="combined_energy_stability_magnesium_carbohydrates")
m.addConstr(14 * x1 + 22 * x2 >= 47, name="combined_energy_stability_vitamin_B5_carbohydrates")
m.addConstr(14 * x1 + 13 * x3 >= 31, name="combined_energy_stability_vitamin_B5_B2")
m.addConstr(20 * x0 + 22 * x2 + 13 * x3 >= 53, name="combined_energy_stability_magnesium_carbohydrates_B2")
m.addConstr(20 * x0 + 14 * x1 + 22 * x2 + 13 * x3 >= 53, name="combined_energy_stability_all")

m.addConstr(-3 * x2 + 2 * x3 >= 0, name="carbohydrates_B2_relation")

m.addConstr(14 * x1 + 22 * x2 <= 219, name="max_energy_stability_vitamin_B5_carbohydrates")
m.addConstr(20 * x0 + 22 * x2 <= 116, name="max_energy_stability_magnesium_carbohydrates")
m.addConstr(14 * x1 + 13 * x3 <= 168, name="max_energy_stability_vitamin_B5_B2")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Milligrams of magnesium: ", x0.varValue)
    print("Milligrams of vitamin B5: ", x1.varValue)
    print("Grams of carbohydrates: ", x2.varValue)
    print("Milligrams of vitamin B2: ", x3.varValue)
else:
    print("The model is infeasible")
