
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
chicken = m.addVar(lb=0, name="chicken")
oranges = m.addVar(lb=0, name="oranges")
cereal = m.addVar(lb=0, name="cereal")
pasta = m.addVar(lb=0, name="pasta")

# Set objective function
m.setObjective(8.6 * chicken + 8.31 * oranges + 4.72 * cereal + 7.32 * pasta, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(34 * chicken + 26 * oranges <= 397, "sourness_limit")  # Resource constraint: sourness
m.addConstr(11 * chicken + 29 * oranges + 5 * cereal + 10 * pasta <= 203, "fat_limit")  # Resource constraint: fat
m.addConstr(23 * chicken + 26 * oranges + 17 * cereal + 14 * pasta <= 174, "carb_limit")  # Resource constraint: carbs

m.addConstr(34 * chicken + 26 * oranges >= 56, "sourness_chicken_oranges_min")
m.addConstr(34 * chicken + 23 * cereal >= 96, "sourness_chicken_cereal_min")
m.addConstr(34 * chicken + 26 * oranges + 23 * cereal + 35 * pasta >= 96, "sourness_total_min")

m.addConstr(11 * chicken + 29 * oranges >= 16, "fat_chicken_oranges_min")
m.addConstr(5 * cereal + 10 * pasta >= 29, "fat_cereal_pasta_min")
m.addConstr(11 * chicken + 5 * cereal >= 48, "fat_chicken_cereal_min")
m.addConstr(11 * chicken + 29 * oranges + 5 * cereal + 10 * pasta >= 48, "fat_total_min")

m.addConstr(23 * chicken + 14 * pasta >= 28, "carb_chicken_pasta_min")
m.addConstr(26 * oranges + 14 * pasta >= 30, "carb_oranges_pasta_min")
m.addConstr(23 * chicken + 17 * cereal >= 41, "carb_chicken_cereal_min")
m.addConstr(23 * chicken + 26 * oranges + 17 * cereal + 14 * pasta >= 41, "carb_total_min")


m.addConstr(34 * chicken + 26 * oranges <= 252, "sourness_chicken_oranges_max")
m.addConstr(26 * oranges + 35 * pasta <= 150, "sourness_oranges_pasta_max")
m.addConstr(23 * cereal + 35 * pasta <= 393, "sourness_cereal_pasta_max")

m.addConstr(29 * oranges + 5 * cereal <= 112, "fat_oranges_cereal_max")
m.addConstr(11 * chicken + 5 * cereal <= 173, "fat_chicken_cereal_max")
m.addConstr(29 * oranges + 10 * pasta <= 98, "fat_oranges_pasta_max")
m.addConstr(11 * chicken + 10 * pasta <= 149, "fat_chicken_pasta_max")
m.addConstr(11 * chicken + 29 * oranges <= 190, "fat_chicken_oranges_max")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

