
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="chicken_drumsticks", lb=0)
x1 = m.addVar(name="oranges", lb=0)
x2 = m.addVar(name="bowls_of_cereal", lb=0)
x3 = m.addVar(name="bowls_of_pasta", lb=0)

# Define the objective function
m.setObjective(8.6*x0 + 8.31*x1 + 4.72*x2 + 7.32*x3, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(34*x0 + 26*x1 >= 56)
m.addConstr(34*x0 + 23*x2 >= 96)
m.addConstr(34*x0 + 26*x1 + 23*x2 + 35*x3 >= 96)
m.addConstr(11*x0 + 29*x1 >= 16)
m.addConstr(5*x2 + 10*x3 >= 29)
m.addConstr(11*x0 + 5*x2 >= 48)
m.addConstr(11*x0 + 29*x1 + 5*x2 + 10*x3 >= 48)
m.addConstr(23*x0 + 14*x3 >= 28)
m.addConstr(26*x1 + 14*x3 >= 30)
m.addConstr(23*x0 + 17*x2 >= 41)
m.addConstr(23*x0 + 26*x1 + 17*x2 + 14*x3 >= 41)
m.addConstr(34*x0 + 26*x1 <= 252)
m.addConstr(26*x1 + 35*x3 <= 150)
m.addConstr(23*x2 + 35*x3 <= 393)
m.addConstr(29*x1 + 5*x2 <= 112)
m.addConstr(11*x0 + 5*x2 <= 173)
m.addConstr(29*x1 + 10*x3 <= 98)
m.addConstr(11*x0 + 10*x3 <= 149)
m.addConstr(11*x0 + 29*x1 <= 190)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Chicken drumsticks: ", x0.varValue)
    print("Oranges: ", x1.varValue)
    print("Bowls of cereal: ", x2.varValue)
    print("Bowls of pasta: ", x3.varValue)
else:
    print("The model is infeasible")
