
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
vitamin_b1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b1")  # Continuous
potassium = model.addVar(lb=0, vtype=GRB.INTEGER, name="potassium")  # Integer

# Set objective function
model.setObjective(1 * vitamin_b1 + 6 * potassium, GRB.MINIMIZE)

# Add constraints
model.addConstr(9 * vitamin_b1 + 2 * potassium >= 9, "c0")  # Cognitive performance (repeated constraint)
model.addConstr(2 * vitamin_b1 + 14 * potassium >= 16, "c1") # Immune support (repeated constraint)
model.addConstr(-10 * vitamin_b1 + 4 * potassium >= 0, "c2")
model.addConstr(9 * vitamin_b1 + 2 * potassium <= 19, "c3")
model.addConstr(2 * vitamin_b1 + 14 * potassium <= 31, "c4")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal value: {model.objVal}")
    print(f"Milligrams of Vitamin B1: {vitamin_b1.x}")
    print(f"Milligrams of Potassium: {potassium.x}")

