
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B1")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="milligrams_of_potassium")

# Define the objective function
m.setObjective(x0 + 6*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(9*x0 + 2*x1 >= 9, "cognitive_performance_min")
m.addConstr(9*x0 + 2*x1 <= 19, "cognitive_performance_max")
m.addConstr(2*x0 + 14*x1 >= 16, "immune_support_min")
m.addConstr(2*x0 + 14*x1 <= 31, "immune_support_max")
m.addConstr(-10*x0 + 4*x1 >= 0, "additional_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B1: {x0.x}")
    print(f"Milligrams of Potassium: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
