
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams_of_vitamin_B1")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams_of_potassium", vtype=gurobi.GRB.INTEGER)

    # Objective function: Minimize 1*x0 + 6*x1
    model.setObjective(1*x0 + 6*x1, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9*x0 + 2*x1 >= 9, name="cognitive_performance_index_min")
    model.addConstr(2*x0 + 14*x1 >= 16, name="immune_support_index_min")
    model.addConstr(-10*x0 + 4*x1 >= 0, name="linear_constraint")
    model.addConstr(9*x0 + 2*x1 <= 19, name="cognitive_performance_index_max")
    model.addConstr(2*x0 + 14*x1 <= 31, name="immune_support_index_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B1: {x0.varValue}")
        print(f"Milligrams of potassium: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
