
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("vitamin_optimization")

# Create variables
vitamin_b6 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b6")
vitamin_b2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="vitamin_b2")
zinc = m.addVar(lb=0, vtype=GRB.INTEGER, name="zinc")

# Set objective function
m.setObjective(9*vitamin_b6**2 + vitamin_b6*zinc + 2*vitamin_b2**2 + vitamin_b2*zinc + zinc**2 + 6*vitamin_b6 + 3*vitamin_b2 + zinc, GRB.MINIMIZE)

# Add constraints
m.addConstr(8.88*vitamin_b6 + 14.45*vitamin_b2 >= 25, "digestive_constraint1")
m.addConstr(8.88*vitamin_b6 + 5.8*zinc >= 30, "digestive_constraint2")
m.addConstr(14.45*vitamin_b2 + 5.8*zinc >= 24, "digestive_constraint3")
m.addConstr(8.88*vitamin_b6 + 14.45*vitamin_b2 + 5.8*zinc >= 24, "digestive_constraint4")
m.addConstr(14.45*vitamin_b2**2 + 5.8*zinc**2 <= 77, "digestive_constraint5") # Note: squared terms in constraint
m.addConstr(8.88*vitamin_b6 + 14.45*vitamin_b2 + 5.8*zinc <= 134, "digestive_constraint6")


m.addConstr(12.48*vitamin_b6 + 8.29*zinc >= 88, "kidney_constraint1")
m.addConstr(10.75*vitamin_b2**2 + 8.29*zinc**2 >= 89, "kidney_constraint2") # Note: squared terms in constraint
m.addConstr(12.48*vitamin_b6 + 10.75*vitamin_b2 + 8.29*zinc >= 89, "kidney_constraint3")
m.addConstr(12.48*vitamin_b6 + 8.29*zinc <= 357, "kidney_constraint4")

m.addConstr(10*vitamin_b6 - 5*zinc >= 0, "constraint7")
m.addConstr(2*vitamin_b2 - 3*zinc >= 0, "constraint8")
m.addConstr(2*vitamin_b6 - 5*vitamin_b2 >= 0, "constraint9")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_b6:', vitamin_b6.x)
    print('vitamin_b2:', vitamin_b2.x)
    print('zinc:', zinc.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
