
from gurobipy import Model, GRB

# Create a new model
model = Model("Resource Allocation")

# Create variables
variables = {
    'color printers': model.addVar(vtype=GRB.INTEGER, name='x0'),
    'lanyards': model.addVar(vtype=GRB.INTEGER, name='x1'),
    'mechanical pencils': model.addVar(vtype=GRB.INTEGER, name='x2'),
    'red highlighters': model.addVar(vtype=GRB.INTEGER, name='x3')
}

# Set objective function
model.setObjective(6 * variables['color printers'] + 1 * variables['lanyards'] + 4 * variables['mechanical pencils'] + 6 * variables['red highlighters'], GRB.MAXIMIZE)

# Add constraints
model.addConstr(32 * variables['color printers'] + 14 * variables['lanyards'] + 13 * variables['mechanical pencils'] >= 92, "c1")
model.addConstr(32 * variables['color printers'] + 13 * variables['mechanical pencils'] + 30 * variables['red highlighters'] >= 92, "c2")
model.addConstr(32 * variables['color printers'] + 14 * variables['lanyards'] + 13 * variables['mechanical pencils'] >= 65, "c3")
model.addConstr(32 * variables['color printers'] + 13 * variables['mechanical pencils'] + 30 * variables['red highlighters'] >= 65, "c4")

model.addConstr(15 * variables['color printers'] + 25 * variables['lanyards'] >= 20, "c5")
model.addConstr(15 * variables['mechanical pencils'] + 30 * variables['red highlighters'] >= 26, "c6")
model.addConstr(25 * variables['lanyards'] + 15 * variables['mechanical pencils'] + 30 * variables['red highlighters'] >= 42, "c7")
model.addConstr(15 * variables['color printers'] + 15 * variables['mechanical pencils'] + 30 * variables['red highlighters'] >= 42, "c8")
model.addConstr(25 * variables['lanyards'] + 15 * variables['mechanical pencils'] + 30 * variables['red highlighters'] >= 35, "c9")
model.addConstr(15 * variables['color printers'] + 15 * variables['mechanical pencils'] + 30 * variables['red highlighters'] >= 35, "c10")


model.addConstr(14 * variables['lanyards'] + 13 * variables['mechanical pencils'] <= 314, "c11")
model.addConstr(14 * variables['lanyards'] + 30 * variables['red highlighters'] <= 116, "c12")
model.addConstr(13 * variables['mechanical pencils'] + 30 * variables['red highlighters'] <= 143, "c13")
model.addConstr(32 * variables['color printers'] + 14 * variables['lanyards'] + 13 * variables['mechanical pencils'] <= 321, "c14")
model.addConstr(32 * variables['color printers'] + 13 * variables['mechanical pencils'] + 30 * variables['red highlighters'] <= 311, "c15")
model.addConstr(14 * variables['lanyards'] + 13 * variables['mechanical pencils'] + 30 * variables['red highlighters'] <= 336, "c16")
model.addConstr(32 * variables['color printers'] + 14 * variables['lanyards'] + 13 * variables['mechanical pencils'] + 30 * variables['red highlighters'] <= 336, "c17")

model.addConstr(25 * variables['lanyards'] + 30 * variables['red highlighters'] <= 62, "c18")
model.addConstr(25 * variables['lanyards'] + 15 * variables['mechanical pencils'] <= 167, "c19")
model.addConstr(15 * variables['color printers'] + 30 * variables['red highlighters'] <= 127, "c20")
model.addConstr(15 * variables['color printers'] + 25 * variables['lanyards'] + 15 * variables['mechanical pencils'] <= 184, "c21")
model.addConstr(15 * variables['color printers'] + 15 * variables['mechanical pencils'] + 30 * variables['red highlighters'] <= 216, "c22")
model.addConstr(25 * variables['lanyards'] + 15 * variables['mechanical pencils'] + 30 * variables['red highlighters'] <= 67, "c23")
model.addConstr(15 * variables['color printers'] + 25 * variables['lanyards'] + 15 * variables['mechanical pencils'] + 30 * variables['red highlighters'] <= 67, "c24")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for var in variables:
        print(f"{var}: {variables[var].x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

