
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables (all integer)
x0 = m.addVar(vtype=GRB.INTEGER, name="color_printers")
x1 = m.addVar(vtype=GRB.INTEGER, name="lanyards")
x2 = m.addVar(vtype=GRB.INTEGER, name="mechanical_pencils")
x3 = m.addVar(vtype=GRB.INTEGER, name="red_highlighters")

# Objective function
m.setObjective(6*x0 + 1*x1 + 4*x2 + 6*x3, GRB.MAXIMIZE)

# Constraints based on provided information
m.addConstr(32*x0 + 14*x1 + 13*x2 >= 92, name="satisfaction_1")
m.addConstr(32*x0 + 13*x2 + 30*x3 >= 92, name="satisfaction_2")
m.addConstr(32*x0 + 14*x1 + 13*x2 >= 65, name="satisfaction_3")
m.addConstr(32*x0 + 13*x2 + 30*x3 >= 65, name="satisfaction_4")

m.addConstr(15*x0 + 25*x1 >= 20, name="storage_1")
m.addConstr(15*x2 + 30*x3 >= 26, name="storage_2")
m.addConstr(25*x1 + 15*x2 + 30*x3 >= 42, name="storage_3")
m.addConstr(15*x0 + 15*x2 + 30*x3 >= 42, name="storage_4")
m.addConstr(25*x1 + 15*x2 + 30*x3 >= 35, name="storage_5")
m.addConstr(15*x0 + 15*x2 + 30*x3 >= 35, name="storage_6")

m.addConstr(14*x1 + 13*x2 <= 314, name="satisfaction_limit_1")
m.addConstr(14*x1 + 30*x3 <= 116, name="satisfaction_limit_2")
m.addConstr(13*x2 + 30*x3 <= 143, name="satisfaction_limit_3")
m.addConstr(32*x0 + 14*x1 + 13*x2 <= 321, name="satisfaction_limit_4")
m.addConstr(32*x0 + 13*x2 + 30*x3 <= 311, name="satisfaction_limit_5")
m.addConstr(14*x1 + 13*x2 + 30*x3 <= 336, name="satisfaction_limit_6")
m.addConstr(32*x0 + 14*x1 + 13*x2 + 30*x3 <= 336, name="total_satisfaction_limit")

m.addConstr(25*x1 + 30*x3 <= 62, name="storage_limit_1")
m.addConstr(25*x1 + 15*x2 <= 167, name="storage_limit_2")
m.addConstr(15*x0 + 30*x3 <= 127, name="storage_limit_3")
m.addConstr(15*x0 + 25*x1 + 15*x2 <= 184, name="storage_limit_4")
m.addConstr(15*x0 + 15*x2 + 30*x3 <= 216, name="storage_limit_5")
m.addConstr(25*x1 + 15*x2 + 30*x3 <= 67, name="storage_limit_6")
m.addConstr(15*x0 + 25*x1 + 15*x2 + 30*x3 <= 67, name="total_storage_limit")

# Solve the model
m.optimize()

print("Objective Function Value: ", m.objVal)
for v in m.getVars():
    print(v.varName, ":", v.x)
