
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
color_printers = m.addVar(name="color_printers", vtype=gp.GRB.INTEGER)
lanyards = m.addVar(name="lanyards", vtype=gp.GRB.INTEGER)
mechanical_pencils = m.addVar(name="mechanical_pencils", vtype=gp.GRB.INTEGER)
red_highlighters = m.addVar(name="red_highlighters", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(6 * color_printers + lanyards + 4 * mechanical_pencils + 6 * red_highlighters, gp.GRB.MAXIMIZE)

# Constraints
# Resource coefficients
r0 = {'color_printers': 32, 'lanyards': 14, 'mechanical_pencils': 13, 'red_highlighters': 30}
r1 = {'color_printers': 15, 'lanyards': 25, 'mechanical_pencils': 15, 'red_highlighters': 30}

# Employee satisfaction impact constraints
m.addConstr(r0['color_printers'] * color_printers + r0['lanyards'] * lanyards + r0['mechanical_pencils'] * mechanical_pencils >= 92, name="min_satisfaction_1")
m.addConstr(r0['color_printers'] * color_printers + r0['mechanical_pencils'] * mechanical_pencils + r0['red_highlighters'] * red_highlighters >= 92, name="min_satisfaction_2")
m.addConstr(r0['color_printers'] * color_printers + r0['lanyards'] * lanyards + r0['mechanical_pencils'] * mechanical_pencils >= 65, name="min_satisfaction_3")
m.addConstr(r0['color_printers'] * color_printers + r0['mechanical_pencils'] * mechanical_pencils + r0['red_highlighters'] * red_highlighters >= 65, name="min_satisfaction_4")

# Storage space constraints
m.addConstr(r1['color_printers'] * color_printers + r1['lanyards'] * lanyards >= 20, name="storage_1")
m.addConstr(r1['mechanical_pencils'] * mechanical_pencils + r1['red_highlighters'] * red_highlighters >= 26, name="storage_2")
m.addConstr(r1['lanyards'] * lanyards + r1['mechanical_pencils'] * mechanical_pencils + r1['red_highlighters'] * red_highlighters >= 42, name="storage_3")
m.addConstr(r1['color_printers'] * color_printers + r1['mechanical_pencils'] * mechanical_pencils + r1['red_highlighters'] * red_highlighters >= 42, name="storage_4")
m.addConstr(r1['lanyards'] * lanyards + r1['mechanical_pencils'] * mechanical_pencils + r1['red_highlighters'] * red_highlighters >= 35, name="storage_5")
m.addConstr(r1['color_printers'] * color_printers + r1['mechanical_pencils'] * mechanical_pencils + r1['red_highlighters'] * red_highlighters >= 35, name="storage_6")

# Upper bounds for employee satisfaction impact
m.addConstr(r0['lanyards'] * lanyards + r0['mechanical_pencils'] * mechanical_pencils <= 314, name="upper_bound_1")
m.addConstr(r0['lanyards'] * lanyards + r0['red_highlighters'] * red_highlighters <= 116, name="upper_bound_2")
m.addConstr(r0['mechanical_pencils'] * mechanical_pencils + r0['red_highlighters'] * red_highlighters <= 143, name="upper_bound_3")
m.addConstr(r0['color_printers'] * color_printers + r0['lanyards'] * lanyards + r0['mechanical_pencils'] * mechanical_pencils <= 321, name="upper_bound_4")
m.addConstr(r0['color_printers'] * color_printers + r0['mechanical_pencils'] * mechanical_pencils + r0['red_highlighters'] * red_highlighters <= 311, name="upper_bound_5")
m.addConstr(r0['lanyards'] * lanyards + r0['mechanical_pencils'] * mechanical_pencils + r0['red_highlighters'] * red_highlighters <= 336, name="upper_bound_6")
m.addConstr(r0['color_printers'] * color_printers + r0['lanyards'] * lanyards + r0['mechanical_pencils'] * mechanical_pencils + r0['red_highlighters'] * red_highlighters <= 336, name="upper_bound_7")

# Upper bounds for storage space
m.addConstr(r1['lanyards'] * lanyards + r1['red_highlighters'] * red_highlighters <= 62, name="storage_upper_bound_1")
m.addConstr(r1['lanyards'] * lanyards + r1['mechanical_pencils'] * mechanical_pencils <= 167, name="storage_upper_bound_2")
m.addConstr(r1['color_printers'] * color_printers + r1['red_highlighters'] * red_highlighters <= 127, name="storage_upper_bound_3")
m.addConstr(r1['color_printers'] * color_printers + r1['lanyards'] * lanyards + r1['mechanical_pencils'] * mechanical_pencils <= 184, name="storage_upper_bound_4")
m.addConstr(r1['color_printers'] * color_printers + r1['mechanical_pencils'] * mechanical_pencils + r1['red_highlighters'] * red_highlighters <= 216, name="storage_upper_bound_5")
m.addConstr(r1['lanyards'] * lanyards + r1['mechanical_pencils'] * mechanical_pencils + r1['red_highlighters'] * red_highlighters <= 67, name="storage_upper_bound_6")
m.addConstr(r1['color_printers'] * color_printers + r1['lanyards'] * lanyards + r1['mechanical_pencils'] * mechanical_pencils + r1['red_highlighters'] * red_highlighters <= 67, name="storage_upper_bound_7")

# Optimize
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Color Printers: ", color_printers.varValue)
    print("Lanyards: ", lanyards.varValue)
    print("Mechanical Pencils: ", mechanical_pencils.varValue)
    print("Red Highlighters: ", red_highlighters.varValue)
else:
    print("No solution found")
