
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
carbohydrates = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carbohydrates")
vitamin_b4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")
vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")

# Set objective function
m.setObjective(8.48 * magnesium + 5.91 * carbohydrates + 6.67 * vitamin_b4 + 5.11 * vitamin_a, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4.39 * magnesium + 6.81 * carbohydrates >= 50, "c1")
m.addConstr(4.39 * magnesium + 0.77 * vitamin_b4 >= 66, "c2")
m.addConstr(6.81 * carbohydrates + 3.47 * vitamin_a >= 73, "c3")
m.addConstr(4.39 * magnesium + 6.81 * carbohydrates + 0.77 * vitamin_b4 + 3.47 * vitamin_a >= 73, "c4")
m.addConstr(-2 * magnesium + carbohydrates >= 0, "c5")
m.addConstr(-10 * vitamin_b4 + 3 * vitamin_a >= 0, "c6")
m.addConstr(4.39 * magnesium + 3.47 * vitamin_a <= 366, "c7")
m.addConstr(4.39 * magnesium + 0.77 * vitamin_b4 + 3.47 * vitamin_a <= 431, "c8")
m.addConstr(4.39 * magnesium + 6.81 * carbohydrates + 0.77 * vitamin_b4 <= 435, "c9")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('magnesium:', magnesium.x)
    print('carbohydrates:', carbohydrates.x)
    print('vitamin_b4:', vitamin_b4.x)
    print('vitamin_a:', vitamin_a.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

