
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    magnesium = model.addVar(name="magnesium", lb=-gurobi.GRB.INFINITY)
    carbohydrates = model.addVar(name="carbohydrates", lb=-gurobi.GRB.INFINITY)
    vitamin_B4 = model.addVar(name="vitamin_B4", lb=-gurobi.GRB.INFINITY)
    vitamin_A = model.addVar(name="vitamin_A", lb=-gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(8.48 * magnesium + 5.91 * carbohydrates + 6.67 * vitamin_B4 + 5.11 * vitamin_A, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4.39 * magnesium + 6.81 * carbohydrates >= 50)
    model.addConstr(4.39 * magnesium + 0.77 * vitamin_B4 >= 66)
    model.addConstr(6.81 * carbohydrates + 3.47 * vitamin_A >= 73)
    model.addConstr(4.39 * magnesium + 6.81 * carbohydrates + 0.77 * vitamin_B4 + 3.47 * vitamin_A >= 73)
    model.addConstr(-2 * magnesium + carbohydrates >= 0)
    model.addConstr(-10 * vitamin_B4 + 3 * vitamin_A >= 0)
    model.addConstr(4.39 * magnesium + 3.47 * vitamin_A <= 366)
    model.addConstr(4.39 * magnesium + 0.77 * vitamin_B4 + 3.47 * vitamin_A <= 431)
    model.addConstr(4.39 * magnesium + 6.81 * carbohydrates + 0.77 * vitamin_B4 <= 435)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Magnesium: {magnesium.x}")
        print(f"Carbohydrates: {carbohydrates.x}")
        print(f"Vitamin B4: {vitamin_B4.x}")
        print(f"Vitamin A: {vitamin_A.x}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("No feasible solution found.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
