
import gurobipy as gp

# Create a new model
m = gp.Model("Work_Optimization")

# Create variables
laura_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")
bobby_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby_hours")
peggy_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy_hours")
dale_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale_hours")
john_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john_hours")

# Set objective function
m.setObjective(5 * laura_hours + 7 * bobby_hours + peggy_hours + 3 * dale_hours + 6 * john_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(9 * laura_hours + 20 * dale_hours >= 57)
m.addConstr(6 * peggy_hours + 17 * john_hours >= 62)
m.addConstr(9 * laura_hours + 17 * john_hours >= 53)
m.addConstr(9 * laura_hours + 6 * peggy_hours + 17 * john_hours >= 44)
m.addConstr(15 * bobby_hours + 6 * peggy_hours + 17 * john_hours >= 44)
m.addConstr(15 * bobby_hours + 20 * dale_hours + 17 * john_hours >= 44)
m.addConstr(6 * peggy_hours + 20 * dale_hours + 17 * john_hours >= 44)
m.addConstr(9 * laura_hours + 6 * peggy_hours + 17 * john_hours >= 54)
m.addConstr(15 * bobby_hours + 6 * peggy_hours + 17 * john_hours >= 54)
m.addConstr(15 * bobby_hours + 20 * dale_hours + 17 * john_hours >= 54)
m.addConstr(6 * peggy_hours + 20 * dale_hours + 17 * john_hours >= 54)
m.addConstr(9 * laura_hours + 6 * peggy_hours + 17 * john_hours >= 50)
m.addConstr(15 * bobby_hours + 6 * peggy_hours + 17 * john_hours >= 50)
m.addConstr(15 * bobby_hours + 20 * dale_hours + 17 * john_hours >= 50)
m.addConstr(6 * peggy_hours + 20 * dale_hours + 17 * john_hours >= 50)
m.addConstr(9 * laura_hours + 6 * peggy_hours + 17 * john_hours >= 60)
m.addConstr(15 * bobby_hours + 6 * peggy_hours + 17 * john_hours >= 60)
m.addConstr(15 * bobby_hours + 20 * dale_hours + 17 * john_hours >= 60)
m.addConstr(6 * peggy_hours + 20 * dale_hours + 17 * john_hours >= 60)


m.addConstr(5 * bobby_hours + 11 * peggy_hours >= 150)
m.addConstr(19 * laura_hours + 11 * dale_hours >= 75)
m.addConstr(19 * laura_hours + 6 * john_hours >= 104)
m.addConstr(5 * bobby_hours + 11 * dale_hours >= 117)
m.addConstr(19 * laura_hours + 5 * bobby_hours >= 79)

# ... (Add all other organization score constraints similarly)

m.addConstr(3 * bobby_hours - 3 * peggy_hours >= 0)
m.addConstr(9 * laura_hours + 17 * john_hours <= 171)
m.addConstr(15 * bobby_hours + 20 * dale_hours <= 120)
m.addConstr(9 * laura_hours + 15 * bobby_hours + 6 * peggy_hours + 20 * dale_hours + 17 * john_hours <= 120)

# ... (Add all other organization score upper bound constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

